# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSddcDetails(object):
    """
    Details of the SDDC.
    """

    #: A constant which can be used with the hcx_mode property of a CreateSddcDetails.
    #: This constant has a value of "DISABLED"
    HCX_MODE_DISABLED = "DISABLED"

    #: A constant which can be used with the hcx_mode property of a CreateSddcDetails.
    #: This constant has a value of "ADVANCED"
    HCX_MODE_ADVANCED = "ADVANCED"

    #: A constant which can be used with the hcx_mode property of a CreateSddcDetails.
    #: This constant has a value of "ENTERPRISE"
    HCX_MODE_ENTERPRISE = "ENTERPRISE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSddcDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateSddcDetails.
        :type display_name: str

        :param vmware_software_version:
            The value to assign to the vmware_software_version property of this CreateSddcDetails.
        :type vmware_software_version: str

        :param esxi_software_version:
            The value to assign to the esxi_software_version property of this CreateSddcDetails.
        :type esxi_software_version: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateSddcDetails.
        :type compartment_id: str

        :param hcx_mode:
            The value to assign to the hcx_mode property of this CreateSddcDetails.
            Allowed values for this property are: "DISABLED", "ADVANCED", "ENTERPRISE"
        :type hcx_mode: str

        :param initial_configuration:
            The value to assign to the initial_configuration property of this CreateSddcDetails.
        :type initial_configuration: oci.ocvp.models.InitialConfiguration

        :param is_single_host_sddc:
            The value to assign to the is_single_host_sddc property of this CreateSddcDetails.
        :type is_single_host_sddc: bool

        :param ssh_authorized_keys:
            The value to assign to the ssh_authorized_keys property of this CreateSddcDetails.
        :type ssh_authorized_keys: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSddcDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSddcDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'vmware_software_version': 'str',
            'esxi_software_version': 'str',
            'compartment_id': 'str',
            'hcx_mode': 'str',
            'initial_configuration': 'InitialConfiguration',
            'is_single_host_sddc': 'bool',
            'ssh_authorized_keys': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'vmware_software_version': 'vmwareSoftwareVersion',
            'esxi_software_version': 'esxiSoftwareVersion',
            'compartment_id': 'compartmentId',
            'hcx_mode': 'hcxMode',
            'initial_configuration': 'initialConfiguration',
            'is_single_host_sddc': 'isSingleHostSddc',
            'ssh_authorized_keys': 'sshAuthorizedKeys',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._vmware_software_version = None
        self._esxi_software_version = None
        self._compartment_id = None
        self._hcx_mode = None
        self._initial_configuration = None
        self._is_single_host_sddc = None
        self._ssh_authorized_keys = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateSddcDetails.
        A descriptive name for the SDDC.
        SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region.
        Avoid entering confidential information.


        :return: The display_name of this CreateSddcDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateSddcDetails.
        A descriptive name for the SDDC.
        SDDC name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateSddcDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def vmware_software_version(self):
        """
        **[Required]** Gets the vmware_software_version of this CreateSddcDetails.
        The VMware software bundle to install on the ESXi hosts in the SDDC. To get a
        list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :return: The vmware_software_version of this CreateSddcDetails.
        :rtype: str
        """
        return self._vmware_software_version

    @vmware_software_version.setter
    def vmware_software_version(self, vmware_software_version):
        """
        Sets the vmware_software_version of this CreateSddcDetails.
        The VMware software bundle to install on the ESXi hosts in the SDDC. To get a
        list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :param vmware_software_version: The vmware_software_version of this CreateSddcDetails.
        :type: str
        """
        self._vmware_software_version = vmware_software_version

    @property
    def esxi_software_version(self):
        """
        Gets the esxi_software_version of this CreateSddcDetails.
        The ESXi software bundle to install on the ESXi hosts in the SDDC.
        Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted.
        To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :return: The esxi_software_version of this CreateSddcDetails.
        :rtype: str
        """
        return self._esxi_software_version

    @esxi_software_version.setter
    def esxi_software_version(self, esxi_software_version):
        """
        Sets the esxi_software_version of this CreateSddcDetails.
        The ESXi software bundle to install on the ESXi hosts in the SDDC.
        Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted.
        To get a list of the available versions, use
        :func:`list_supported_vmware_software_versions`.


        :param esxi_software_version: The esxi_software_version of this CreateSddcDetails.
        :type: str
        """
        self._esxi_software_version = esxi_software_version

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateSddcDetails.
        The `OCID`__ of the compartment to contain the SDDC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateSddcDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateSddcDetails.
        The `OCID`__ of the compartment to contain the SDDC.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateSddcDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def hcx_mode(self):
        """
        **[Required]** Gets the hcx_mode of this CreateSddcDetails.
        HCX configuration of the SDDC.

        Allowed values for this property are: "DISABLED", "ADVANCED", "ENTERPRISE"


        :return: The hcx_mode of this CreateSddcDetails.
        :rtype: str
        """
        return self._hcx_mode

    @hcx_mode.setter
    def hcx_mode(self, hcx_mode):
        """
        Sets the hcx_mode of this CreateSddcDetails.
        HCX configuration of the SDDC.


        :param hcx_mode: The hcx_mode of this CreateSddcDetails.
        :type: str
        """
        allowed_values = ["DISABLED", "ADVANCED", "ENTERPRISE"]
        if not value_allowed_none_or_none_sentinel(hcx_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `hcx_mode`, must be None or one of {allowed_values}"
            )
        self._hcx_mode = hcx_mode

    @property
    def initial_configuration(self):
        """
        **[Required]** Gets the initial_configuration of this CreateSddcDetails.

        :return: The initial_configuration of this CreateSddcDetails.
        :rtype: oci.ocvp.models.InitialConfiguration
        """
        return self._initial_configuration

    @initial_configuration.setter
    def initial_configuration(self, initial_configuration):
        """
        Sets the initial_configuration of this CreateSddcDetails.

        :param initial_configuration: The initial_configuration of this CreateSddcDetails.
        :type: oci.ocvp.models.InitialConfiguration
        """
        self._initial_configuration = initial_configuration

    @property
    def is_single_host_sddc(self):
        """
        Gets the is_single_host_sddc of this CreateSddcDetails.
        Indicates whether this SDDC is designated for only single ESXi host.


        :return: The is_single_host_sddc of this CreateSddcDetails.
        :rtype: bool
        """
        return self._is_single_host_sddc

    @is_single_host_sddc.setter
    def is_single_host_sddc(self, is_single_host_sddc):
        """
        Sets the is_single_host_sddc of this CreateSddcDetails.
        Indicates whether this SDDC is designated for only single ESXi host.


        :param is_single_host_sddc: The is_single_host_sddc of this CreateSddcDetails.
        :type: bool
        """
        self._is_single_host_sddc = is_single_host_sddc

    @property
    def ssh_authorized_keys(self):
        """
        **[Required]** Gets the ssh_authorized_keys of this CreateSddcDetails.
        One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for
        the default user on each ESXi host. Use a newline character to separate multiple keys.
        The SSH keys must be in the format required for the `authorized_keys` file


        :return: The ssh_authorized_keys of this CreateSddcDetails.
        :rtype: str
        """
        return self._ssh_authorized_keys

    @ssh_authorized_keys.setter
    def ssh_authorized_keys(self, ssh_authorized_keys):
        """
        Sets the ssh_authorized_keys of this CreateSddcDetails.
        One or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for
        the default user on each ESXi host. Use a newline character to separate multiple keys.
        The SSH keys must be in the format required for the `authorized_keys` file


        :param ssh_authorized_keys: The ssh_authorized_keys of this CreateSddcDetails.
        :type: str
        """
        self._ssh_authorized_keys = ssh_authorized_keys

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateSddcDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateSddcDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateSddcDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateSddcDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateSddcDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateSddcDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateSddcDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateSddcDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
