# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApproverDetail(object):
    """
    details of Approver Detail.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApproverDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param approver_id:
            The value to assign to the approver_id property of this ApproverDetail.
        :type approver_id: str

        :param approval_action:
            The value to assign to the approval_action property of this ApproverDetail.
        :type approval_action: str

        :param approval_comment:
            The value to assign to the approval_comment property of this ApproverDetail.
        :type approval_comment: str

        :param approval_additional_message:
            The value to assign to the approval_additional_message property of this ApproverDetail.
        :type approval_additional_message: str

        :param time_of_authorization:
            The value to assign to the time_of_authorization property of this ApproverDetail.
        :type time_of_authorization: datetime

        :param time_approved_for_access:
            The value to assign to the time_approved_for_access property of this ApproverDetail.
        :type time_approved_for_access: datetime

        """
        self.swagger_types = {
            'approver_id': 'str',
            'approval_action': 'str',
            'approval_comment': 'str',
            'approval_additional_message': 'str',
            'time_of_authorization': 'datetime',
            'time_approved_for_access': 'datetime'
        }
        self.attribute_map = {
            'approver_id': 'approverId',
            'approval_action': 'approvalAction',
            'approval_comment': 'approvalComment',
            'approval_additional_message': 'approvalAdditionalMessage',
            'time_of_authorization': 'timeOfAuthorization',
            'time_approved_for_access': 'timeApprovedForAccess'
        }
        self._approver_id = None
        self._approval_action = None
        self._approval_comment = None
        self._approval_additional_message = None
        self._time_of_authorization = None
        self._time_approved_for_access = None

    @property
    def approver_id(self):
        """
        Gets the approver_id of this ApproverDetail.
        The userId of the approver.


        :return: The approver_id of this ApproverDetail.
        :rtype: str
        """
        return self._approver_id

    @approver_id.setter
    def approver_id(self, approver_id):
        """
        Sets the approver_id of this ApproverDetail.
        The userId of the approver.


        :param approver_id: The approver_id of this ApproverDetail.
        :type: str
        """
        self._approver_id = approver_id

    @property
    def approval_action(self):
        """
        Gets the approval_action of this ApproverDetail.
        The action done by the approver.


        :return: The approval_action of this ApproverDetail.
        :rtype: str
        """
        return self._approval_action

    @approval_action.setter
    def approval_action(self, approval_action):
        """
        Sets the approval_action of this ApproverDetail.
        The action done by the approver.


        :param approval_action: The approval_action of this ApproverDetail.
        :type: str
        """
        self._approval_action = approval_action

    @property
    def approval_comment(self):
        """
        Gets the approval_comment of this ApproverDetail.
        Comment specified by the approver of the request.


        :return: The approval_comment of this ApproverDetail.
        :rtype: str
        """
        return self._approval_comment

    @approval_comment.setter
    def approval_comment(self, approval_comment):
        """
        Sets the approval_comment of this ApproverDetail.
        Comment specified by the approver of the request.


        :param approval_comment: The approval_comment of this ApproverDetail.
        :type: str
        """
        self._approval_comment = approval_comment

    @property
    def approval_additional_message(self):
        """
        Gets the approval_additional_message of this ApproverDetail.
        Additional message specified by the approver of the request.


        :return: The approval_additional_message of this ApproverDetail.
        :rtype: str
        """
        return self._approval_additional_message

    @approval_additional_message.setter
    def approval_additional_message(self, approval_additional_message):
        """
        Sets the approval_additional_message of this ApproverDetail.
        Additional message specified by the approver of the request.


        :param approval_additional_message: The approval_additional_message of this ApproverDetail.
        :type: str
        """
        self._approval_additional_message = approval_additional_message

    @property
    def time_of_authorization(self):
        """
        Gets the time_of_authorization of this ApproverDetail.
        Time when the access request was authorized by the customer in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_of_authorization of this ApproverDetail.
        :rtype: datetime
        """
        return self._time_of_authorization

    @time_of_authorization.setter
    def time_of_authorization(self, time_of_authorization):
        """
        Sets the time_of_authorization of this ApproverDetail.
        Time when the access request was authorized by the customer in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_of_authorization: The time_of_authorization of this ApproverDetail.
        :type: datetime
        """
        self._time_of_authorization = time_of_authorization

    @property
    def time_approved_for_access(self):
        """
        Gets the time_approved_for_access of this ApproverDetail.
        Time for when the access request should start that is authorized by the customer in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_approved_for_access of this ApproverDetail.
        :rtype: datetime
        """
        return self._time_approved_for_access

    @time_approved_for_access.setter
    def time_approved_for_access(self, time_approved_for_access):
        """
        Sets the time_approved_for_access of this ApproverDetail.
        Time for when the access request should start that is authorized by the customer in `RFC 3339`__ timestamp format.Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_approved_for_access: The time_approved_for_access of this ApproverDetail.
        :type: datetime
        """
        self._time_approved_for_access = time_approved_for_access

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
