# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VmcoreDetails(object):
    """
    Kernel event vmcore details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VmcoreDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backtrace:
            The value to assign to the backtrace property of this VmcoreDetails.
        :type backtrace: str

        :param component:
            The value to assign to the component property of this VmcoreDetails.
        :type component: str

        """
        self.swagger_types = {
            'backtrace': 'str',
            'component': 'str'
        }
        self.attribute_map = {
            'backtrace': 'backtrace',
            'component': 'component'
        }
        self._backtrace = None
        self._component = None

    @property
    def backtrace(self):
        """
        **[Required]** Gets the backtrace of this VmcoreDetails.
        Kernel vmcore backtrace.


        :return: The backtrace of this VmcoreDetails.
        :rtype: str
        """
        return self._backtrace

    @backtrace.setter
    def backtrace(self, backtrace):
        """
        Sets the backtrace of this VmcoreDetails.
        Kernel vmcore backtrace.


        :param backtrace: The backtrace of this VmcoreDetails.
        :type: str
        """
        self._backtrace = backtrace

    @property
    def component(self):
        """
        **[Required]** Gets the component of this VmcoreDetails.
        Kernel vmcore component.


        :return: The component of this VmcoreDetails.
        :rtype: str
        """
        return self._component

    @component.setter
    def component(self, component):
        """
        Sets the component of this VmcoreDetails.
        Kernel vmcore component.


        :param component: The component of this VmcoreDetails.
        :type: str
        """
        self._component = component

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
