# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentReceiverProperties(object):
    """
    Properties for agent receiver.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentReceiverProperties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param listener_port:
            The value to assign to the listener_port property of this AgentReceiverProperties.
        :type listener_port: int

        """
        self.swagger_types = {
            'listener_port': 'int'
        }
        self.attribute_map = {
            'listener_port': 'listenerPort'
        }
        self._listener_port = None

    @property
    def listener_port(self):
        """
        **[Required]** Gets the listener_port of this AgentReceiverProperties.
        Receiver listener port.


        :return: The listener_port of this AgentReceiverProperties.
        :rtype: int
        """
        return self._listener_port

    @listener_port.setter
    def listener_port(self, listener_port):
        """
        Sets the listener_port of this AgentReceiverProperties.
        Receiver listener port.


        :param listener_port: The listener_port of this AgentReceiverProperties.
        :type: int
        """
        self._listener_port = listener_port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
