# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlexTunnelBgpStatus(object):
    """
    Boarder Gateway Protocol (BGP) session status
    """

    #: A constant which can be used with the bgp_session_status property of a FlexTunnelBgpStatus.
    #: This constant has a value of "UP"
    BGP_SESSION_STATUS_UP = "UP"

    #: A constant which can be used with the bgp_session_status property of a FlexTunnelBgpStatus.
    #: This constant has a value of "DOWN"
    BGP_SESSION_STATUS_DOWN = "DOWN"

    #: A constant which can be used with the bgp_session_status_ipv6 property of a FlexTunnelBgpStatus.
    #: This constant has a value of "UP"
    BGP_SESSION_STATUS_IPV6_UP = "UP"

    #: A constant which can be used with the bgp_session_status_ipv6 property of a FlexTunnelBgpStatus.
    #: This constant has a value of "DOWN"
    BGP_SESSION_STATUS_IPV6_DOWN = "DOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new FlexTunnelBgpStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param flex_tunnel_id:
            The value to assign to the flex_tunnel_id property of this FlexTunnelBgpStatus.
        :type flex_tunnel_id: str

        :param bgp_session_status:
            The value to assign to the bgp_session_status property of this FlexTunnelBgpStatus.
            Allowed values for this property are: "UP", "DOWN"
        :type bgp_session_status: str

        :param bgp_session_status_ipv6:
            The value to assign to the bgp_session_status_ipv6 property of this FlexTunnelBgpStatus.
            Allowed values for this property are: "UP", "DOWN"
        :type bgp_session_status_ipv6: str

        """
        self.swagger_types = {
            'flex_tunnel_id': 'str',
            'bgp_session_status': 'str',
            'bgp_session_status_ipv6': 'str'
        }
        self.attribute_map = {
            'flex_tunnel_id': 'flexTunnelId',
            'bgp_session_status': 'bgpSessionStatus',
            'bgp_session_status_ipv6': 'bgpSessionStatusIpv6'
        }
        self._flex_tunnel_id = None
        self._bgp_session_status = None
        self._bgp_session_status_ipv6 = None

    @property
    def flex_tunnel_id(self):
        """
        **[Required]** Gets the flex_tunnel_id of this FlexTunnelBgpStatus.
        The `OCID`__ of the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The flex_tunnel_id of this FlexTunnelBgpStatus.
        :rtype: str
        """
        return self._flex_tunnel_id

    @flex_tunnel_id.setter
    def flex_tunnel_id(self, flex_tunnel_id):
        """
        Sets the flex_tunnel_id of this FlexTunnelBgpStatus.
        The `OCID`__ of the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param flex_tunnel_id: The flex_tunnel_id of this FlexTunnelBgpStatus.
        :type: str
        """
        self._flex_tunnel_id = flex_tunnel_id

    @property
    def bgp_session_status(self):
        """
        Gets the bgp_session_status of this FlexTunnelBgpStatus.
        The state of the IPv4 BGP session associated with the flex tunnel.

        Allowed values for this property are: "UP", "DOWN"


        :return: The bgp_session_status of this FlexTunnelBgpStatus.
        :rtype: str
        """
        return self._bgp_session_status

    @bgp_session_status.setter
    def bgp_session_status(self, bgp_session_status):
        """
        Sets the bgp_session_status of this FlexTunnelBgpStatus.
        The state of the IPv4 BGP session associated with the flex tunnel.


        :param bgp_session_status: The bgp_session_status of this FlexTunnelBgpStatus.
        :type: str
        """
        allowed_values = ["UP", "DOWN"]
        if not value_allowed_none_or_none_sentinel(bgp_session_status, allowed_values):
            raise ValueError(
                f"Invalid value for `bgp_session_status`, must be None or one of {allowed_values}"
            )
        self._bgp_session_status = bgp_session_status

    @property
    def bgp_session_status_ipv6(self):
        """
        Gets the bgp_session_status_ipv6 of this FlexTunnelBgpStatus.
        The state of the IPv6 BGP session associated with the flex tunnel.

        Allowed values for this property are: "UP", "DOWN"


        :return: The bgp_session_status_ipv6 of this FlexTunnelBgpStatus.
        :rtype: str
        """
        return self._bgp_session_status_ipv6

    @bgp_session_status_ipv6.setter
    def bgp_session_status_ipv6(self, bgp_session_status_ipv6):
        """
        Sets the bgp_session_status_ipv6 of this FlexTunnelBgpStatus.
        The state of the IPv6 BGP session associated with the flex tunnel.


        :param bgp_session_status_ipv6: The bgp_session_status_ipv6 of this FlexTunnelBgpStatus.
        :type: str
        """
        allowed_values = ["UP", "DOWN"]
        if not value_allowed_none_or_none_sentinel(bgp_session_status_ipv6, allowed_values):
            raise ValueError(
                f"Invalid value for `bgp_session_status_ipv6`, must be None or one of {allowed_values}"
            )
        self._bgp_session_status_ipv6 = bgp_session_status_ipv6

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
