# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_update_details import DrgAttachmentNetworkUpdateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VirtualCircuitDrgAttachmentNetworkUpdateDetails(DrgAttachmentNetworkUpdateDetails):
    """
    Specifies the update details for the virtual circuit attachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VirtualCircuitDrgAttachmentNetworkUpdateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.VirtualCircuitDrgAttachmentNetworkUpdateDetails.type` attribute
        of this class is ``VIRTUAL_CIRCUIT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "LOOPBACK", "INTERNET"
        :type type: str

        :param is_ffab:
            The value to assign to the is_ffab property of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type is_ffab: bool

        :param regional_oci_asn:
            The value to assign to the regional_oci_asn property of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type regional_oci_asn: str

        :param is_edge_pop:
            The value to assign to the is_edge_pop property of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type is_edge_pop: bool

        :param region_name:
            The value to assign to the region_name property of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type region_name: str

        :param transport_only_mode:
            The value to assign to the transport_only_mode property of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type transport_only_mode: bool

        """
        self.swagger_types = {
            'type': 'str',
            'is_ffab': 'bool',
            'regional_oci_asn': 'str',
            'is_edge_pop': 'bool',
            'region_name': 'str',
            'transport_only_mode': 'bool'
        }
        self.attribute_map = {
            'type': 'type',
            'is_ffab': 'isFFAB',
            'regional_oci_asn': 'regionalOciAsn',
            'is_edge_pop': 'isEdgePop',
            'region_name': 'regionName',
            'transport_only_mode': 'transportOnlyMode'
        }
        self._type = None
        self._is_ffab = None
        self._regional_oci_asn = None
        self._is_edge_pop = None
        self._region_name = None
        self._transport_only_mode = None
        self._type = 'VIRTUAL_CIRCUIT'

    @property
    def is_ffab(self):
        """
        Gets the is_ffab of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        Whether the Fast Connect is an FFAB VirtualCircuit.

        Example: `true`


        :return: The is_ffab of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :rtype: bool
        """
        return self._is_ffab

    @is_ffab.setter
    def is_ffab(self, is_ffab):
        """
        Sets the is_ffab of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        Whether the Fast Connect is an FFAB VirtualCircuit.

        Example: `true`


        :param is_ffab: The is_ffab of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type: bool
        """
        self._is_ffab = is_ffab

    @property
    def regional_oci_asn(self):
        """
        Gets the regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        The BGP ASN to use for the virtual circuit's route target.


        :return: The regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :rtype: str
        """
        return self._regional_oci_asn

    @regional_oci_asn.setter
    def regional_oci_asn(self, regional_oci_asn):
        """
        Sets the regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        The BGP ASN to use for the virtual circuit's route target.


        :param regional_oci_asn: The regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type: str
        """
        self._regional_oci_asn = regional_oci_asn

    @property
    def is_edge_pop(self):
        """
        Gets the is_edge_pop of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        Indicates whether FastConnect extends through an edge POP region.

        Example: `true`


        :return: The is_edge_pop of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :rtype: bool
        """
        return self._is_edge_pop

    @is_edge_pop.setter
    def is_edge_pop(self, is_edge_pop):
        """
        Sets the is_edge_pop of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        Indicates whether FastConnect extends through an edge POP region.

        Example: `true`


        :param is_edge_pop: The is_edge_pop of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type: bool
        """
        self._is_edge_pop = is_edge_pop

    @property
    def region_name(self):
        """
        Gets the region_name of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        The OCI region name


        :return: The region_name of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :rtype: str
        """
        return self._region_name

    @region_name.setter
    def region_name(self, region_name):
        """
        Sets the region_name of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        The OCI region name


        :param region_name: The region_name of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type: str
        """
        self._region_name = region_name

    @property
    def transport_only_mode(self):
        """
        Gets the transport_only_mode of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        Boolean flag that determines wether all traffic over the VCs is encrypted.

        Example: `true`


        :return: The transport_only_mode of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :rtype: bool
        """
        return self._transport_only_mode

    @transport_only_mode.setter
    def transport_only_mode(self, transport_only_mode):
        """
        Sets the transport_only_mode of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        Boolean flag that determines wether all traffic over the VCs is encrypted.

        Example: `true`


        :param transport_only_mode: The transport_only_mode of this VirtualCircuitDrgAttachmentNetworkUpdateDetails.
        :type: bool
        """
        self._transport_only_mode = transport_only_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
