# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateWlsDomainCredentialDetails(object):
    """
    The WebLogic domain credential.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateWlsDomainCredentialDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param strategy:
            The value to assign to the strategy property of this UpdateWlsDomainCredentialDetails.
        :type strategy: str

        :param user_secret_id:
            The value to assign to the user_secret_id property of this UpdateWlsDomainCredentialDetails.
        :type user_secret_id: str

        :param password_secret_id:
            The value to assign to the password_secret_id property of this UpdateWlsDomainCredentialDetails.
        :type password_secret_id: str

        """
        self.swagger_types = {
            'strategy': 'str',
            'user_secret_id': 'str',
            'password_secret_id': 'str'
        }
        self.attribute_map = {
            'strategy': 'strategy',
            'user_secret_id': 'userSecretId',
            'password_secret_id': 'passwordSecretId'
        }
        self._strategy = None
        self._user_secret_id = None
        self._password_secret_id = None

    @property
    def strategy(self):
        """
        Gets the strategy of this UpdateWlsDomainCredentialDetails.
        The strategy for passing new WebLogic credential.


        :return: The strategy of this UpdateWlsDomainCredentialDetails.
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """
        Sets the strategy of this UpdateWlsDomainCredentialDetails.
        The strategy for passing new WebLogic credential.


        :param strategy: The strategy of this UpdateWlsDomainCredentialDetails.
        :type: str
        """
        self._strategy = strategy

    @property
    def user_secret_id(self):
        """
        Gets the user_secret_id of this UpdateWlsDomainCredentialDetails.
        The OCID for WebLogic user secret.


        :return: The user_secret_id of this UpdateWlsDomainCredentialDetails.
        :rtype: str
        """
        return self._user_secret_id

    @user_secret_id.setter
    def user_secret_id(self, user_secret_id):
        """
        Sets the user_secret_id of this UpdateWlsDomainCredentialDetails.
        The OCID for WebLogic user secret.


        :param user_secret_id: The user_secret_id of this UpdateWlsDomainCredentialDetails.
        :type: str
        """
        self._user_secret_id = user_secret_id

    @property
    def password_secret_id(self):
        """
        Gets the password_secret_id of this UpdateWlsDomainCredentialDetails.
        The OCID for WebLogic password secret.


        :return: The password_secret_id of this UpdateWlsDomainCredentialDetails.
        :rtype: str
        """
        return self._password_secret_id

    @password_secret_id.setter
    def password_secret_id(self, password_secret_id):
        """
        Sets the password_secret_id of this UpdateWlsDomainCredentialDetails.
        The OCID for WebLogic password secret.


        :param password_secret_id: The password_secret_id of this UpdateWlsDomainCredentialDetails.
        :type: str
        """
        self._password_secret_id = password_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
