# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109

from .processor_config import ProcessorConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InvoiceProcessorConfig(ProcessorConfig):
    """
    The configuration of an invoice processor.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InvoiceProcessorConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_document.models.InvoiceProcessorConfig.processor_type` attribute
        of this class is ``INVOICE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param processor_type:
            The value to assign to the processor_type property of this InvoiceProcessorConfig.
            Allowed values for this property are: "GENERAL", "INVOICE"
        :type processor_type: str

        :param model_id:
            The value to assign to the model_id property of this InvoiceProcessorConfig.
        :type model_id: str

        :param normalization_fields:
            The value to assign to the normalization_fields property of this InvoiceProcessorConfig.
        :type normalization_fields: oci.ai_document.models.NormalizationFields

        """
        self.swagger_types = {
            'processor_type': 'str',
            'model_id': 'str',
            'normalization_fields': 'NormalizationFields'
        }
        self.attribute_map = {
            'processor_type': 'processorType',
            'model_id': 'modelId',
            'normalization_fields': 'normalizationFields'
        }
        self._processor_type = None
        self._model_id = None
        self._normalization_fields = None
        self._processor_type = 'INVOICE'

    @property
    def model_id(self):
        """
        Gets the model_id of this InvoiceProcessorConfig.
        Unique identifier custom model OCID that should be used for inference.


        :return: The model_id of this InvoiceProcessorConfig.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this InvoiceProcessorConfig.
        Unique identifier custom model OCID that should be used for inference.


        :param model_id: The model_id of this InvoiceProcessorConfig.
        :type: str
        """
        self._model_id = model_id

    @property
    def normalization_fields(self):
        """
        **[Required]** Gets the normalization_fields of this InvoiceProcessorConfig.

        :return: The normalization_fields of this InvoiceProcessorConfig.
        :rtype: oci.ai_document.models.NormalizationFields
        """
        return self._normalization_fields

    @normalization_fields.setter
    def normalization_fields(self, normalization_fields):
        """
        Sets the normalization_fields of this InvoiceProcessorConfig.

        :param normalization_fields: The normalization_fields of this InvoiceProcessorConfig.
        :type: oci.ai_document.models.NormalizationFields
        """
        self._normalization_fields = normalization_fields

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
