# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TtsOracleSpeechSettings(object):
    """
    Settings to use for generating speech with a model from ORACLE family.
    """

    #: A constant which can be used with the text_type property of a TtsOracleSpeechSettings.
    #: This constant has a value of "TEXT"
    TEXT_TYPE_TEXT = "TEXT"

    #: A constant which can be used with the text_type property of a TtsOracleSpeechSettings.
    #: This constant has a value of "SSML"
    TEXT_TYPE_SSML = "SSML"

    #: A constant which can be used with the output_format property of a TtsOracleSpeechSettings.
    #: This constant has a value of "MP3"
    OUTPUT_FORMAT_MP3 = "MP3"

    #: A constant which can be used with the output_format property of a TtsOracleSpeechSettings.
    #: This constant has a value of "OGG"
    OUTPUT_FORMAT_OGG = "OGG"

    #: A constant which can be used with the output_format property of a TtsOracleSpeechSettings.
    #: This constant has a value of "PCM"
    OUTPUT_FORMAT_PCM = "PCM"

    #: A constant which can be used with the output_format property of a TtsOracleSpeechSettings.
    #: This constant has a value of "JSON"
    OUTPUT_FORMAT_JSON = "JSON"

    #: A constant which can be used with the speech_mark_types property of a TtsOracleSpeechSettings.
    #: This constant has a value of "SENTENCE"
    SPEECH_MARK_TYPES_SENTENCE = "SENTENCE"

    #: A constant which can be used with the speech_mark_types property of a TtsOracleSpeechSettings.
    #: This constant has a value of "WORD"
    SPEECH_MARK_TYPES_WORD = "WORD"

    def __init__(self, **kwargs):
        """
        Initializes a new TtsOracleSpeechSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param text_type:
            The value to assign to the text_type property of this TtsOracleSpeechSettings.
            Allowed values for this property are: "TEXT", "SSML"
        :type text_type: str

        :param sample_rate_in_hz:
            The value to assign to the sample_rate_in_hz property of this TtsOracleSpeechSettings.
        :type sample_rate_in_hz: int

        :param output_format:
            The value to assign to the output_format property of this TtsOracleSpeechSettings.
            Allowed values for this property are: "MP3", "OGG", "PCM", "JSON"
        :type output_format: str

        :param speech_mark_types:
            The value to assign to the speech_mark_types property of this TtsOracleSpeechSettings.
            Allowed values for items in this list are: "SENTENCE", "WORD"
        :type speech_mark_types: list[str]

        """
        self.swagger_types = {
            'text_type': 'str',
            'sample_rate_in_hz': 'int',
            'output_format': 'str',
            'speech_mark_types': 'list[str]'
        }
        self.attribute_map = {
            'text_type': 'textType',
            'sample_rate_in_hz': 'sampleRateInHz',
            'output_format': 'outputFormat',
            'speech_mark_types': 'speechMarkTypes'
        }
        self._text_type = None
        self._sample_rate_in_hz = None
        self._output_format = None
        self._speech_mark_types = None

    @property
    def text_type(self):
        """
        Gets the text_type of this TtsOracleSpeechSettings.
        The format in which the input text has been supplied i.e., Text or SSML. The supported text types are:
        - TEXT
        - SSML : This is only supported for en-US language.

        Allowed values for this property are: "TEXT", "SSML"


        :return: The text_type of this TtsOracleSpeechSettings.
        :rtype: str
        """
        return self._text_type

    @text_type.setter
    def text_type(self, text_type):
        """
        Sets the text_type of this TtsOracleSpeechSettings.
        The format in which the input text has been supplied i.e., Text or SSML. The supported text types are:
        - TEXT
        - SSML : This is only supported for en-US language.


        :param text_type: The text_type of this TtsOracleSpeechSettings.
        :type: str
        """
        allowed_values = ["TEXT", "SSML"]
        if not value_allowed_none_or_none_sentinel(text_type, allowed_values):
            raise ValueError(
                f"Invalid value for `text_type`, must be None or one of {allowed_values}"
            )
        self._text_type = text_type

    @property
    def sample_rate_in_hz(self):
        """
        Gets the sample_rate_in_hz of this TtsOracleSpeechSettings.
        The sample rate of the generated audio. By default, the audio will be generated with speaker voice sample rate.


        :return: The sample_rate_in_hz of this TtsOracleSpeechSettings.
        :rtype: int
        """
        return self._sample_rate_in_hz

    @sample_rate_in_hz.setter
    def sample_rate_in_hz(self, sample_rate_in_hz):
        """
        Sets the sample_rate_in_hz of this TtsOracleSpeechSettings.
        The sample rate of the generated audio. By default, the audio will be generated with speaker voice sample rate.


        :param sample_rate_in_hz: The sample_rate_in_hz of this TtsOracleSpeechSettings.
        :type: int
        """
        self._sample_rate_in_hz = sample_rate_in_hz

    @property
    def output_format(self):
        """
        Gets the output_format of this TtsOracleSpeechSettings.
        The format of audio in which the user wants the audio to be in. The supported output formats are:
        - MP3
        - OGG
        - PCM
        - JSON

        Allowed values for this property are: "MP3", "OGG", "PCM", "JSON"


        :return: The output_format of this TtsOracleSpeechSettings.
        :rtype: str
        """
        return self._output_format

    @output_format.setter
    def output_format(self, output_format):
        """
        Sets the output_format of this TtsOracleSpeechSettings.
        The format of audio in which the user wants the audio to be in. The supported output formats are:
        - MP3
        - OGG
        - PCM
        - JSON


        :param output_format: The output_format of this TtsOracleSpeechSettings.
        :type: str
        """
        allowed_values = ["MP3", "OGG", "PCM", "JSON"]
        if not value_allowed_none_or_none_sentinel(output_format, allowed_values):
            raise ValueError(
                f"Invalid value for `output_format`, must be None or one of {allowed_values}"
            )
        self._output_format = output_format

    @property
    def speech_mark_types(self):
        """
        Gets the speech_mark_types of this TtsOracleSpeechSettings.
        The kind of time stamp markings the user wants for the audio.
        This property should be provided if outputFormat is json, otherwise it will be ignored.
        null value (i.e. no value is not specified) indicates no speech marking.
        The supported speech mark types are:
        - SENTENCE
        - WORD

        Allowed values for items in this list are: "SENTENCE", "WORD"


        :return: The speech_mark_types of this TtsOracleSpeechSettings.
        :rtype: list[str]
        """
        return self._speech_mark_types

    @speech_mark_types.setter
    def speech_mark_types(self, speech_mark_types):
        """
        Sets the speech_mark_types of this TtsOracleSpeechSettings.
        The kind of time stamp markings the user wants for the audio.
        This property should be provided if outputFormat is json, otherwise it will be ignored.
        null value (i.e. no value is not specified) indicates no speech marking.
        The supported speech mark types are:
        - SENTENCE
        - WORD


        :param speech_mark_types: The speech_mark_types of this TtsOracleSpeechSettings.
        :type: list[str]
        """
        allowed_values = ["SENTENCE", "WORD"]

        if speech_mark_types and speech_mark_types is not NONE_SENTINEL:
            for value in speech_mark_types:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `speech_mark_types`, must be None or one of {allowed_values}"
                    )
        self._speech_mark_types = speech_mark_types

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
