# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240829


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApiPlatformInstance(object):
    """
    A Logical Entity that can be used to create, manage, secure, and advertise APIs to connect to new or existing services
    """

    #: A constant which can be used with the lifecycle_state property of a ApiPlatformInstance.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ApiPlatformInstance.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ApiPlatformInstance.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ApiPlatformInstance.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ApiPlatformInstance.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ApiPlatformInstance.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ApiPlatformInstance object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ApiPlatformInstance.
        :type id: str

        :param description:
            The value to assign to the description property of this ApiPlatformInstance.
        :type description: str

        :param name:
            The value to assign to the name property of this ApiPlatformInstance.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ApiPlatformInstance.
        :type compartment_id: str

        :param idcs_app:
            The value to assign to the idcs_app property of this ApiPlatformInstance.
        :type idcs_app: oci.api_platform.models.IdcsApp

        :param uris:
            The value to assign to the uris property of this ApiPlatformInstance.
        :type uris: oci.api_platform.models.Uris

        :param time_created:
            The value to assign to the time_created property of this ApiPlatformInstance.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ApiPlatformInstance.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ApiPlatformInstance.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ApiPlatformInstance.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ApiPlatformInstance.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ApiPlatformInstance.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ApiPlatformInstance.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'name': 'str',
            'compartment_id': 'str',
            'idcs_app': 'IdcsApp',
            'uris': 'Uris',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'name': 'name',
            'compartment_id': 'compartmentId',
            'idcs_app': 'idcsApp',
            'uris': 'uris',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._description = None
        self._name = None
        self._compartment_id = None
        self._idcs_app = None
        self._uris = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ApiPlatformInstance.
        The `OCID`__ of the instance

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ApiPlatformInstance.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ApiPlatformInstance.
        The `OCID`__ of the instance

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ApiPlatformInstance.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this ApiPlatformInstance.
        User-provided changeable and non-unique description of the instance


        :return: The description of this ApiPlatformInstance.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApiPlatformInstance.
        User-provided changeable and non-unique description of the instance


        :param description: The description of this ApiPlatformInstance.
        :type: str
        """
        self._description = description

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ApiPlatformInstance.
        A regionally unique, non-changeable instance name provided by the user during instance creation


        :return: The name of this ApiPlatformInstance.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiPlatformInstance.
        A regionally unique, non-changeable instance name provided by the user during instance creation


        :param name: The name of this ApiPlatformInstance.
        :type: str
        """
        self._name = name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ApiPlatformInstance.
        The `OCID`__ of the compartment

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ApiPlatformInstance.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ApiPlatformInstance.
        The `OCID`__ of the compartment

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ApiPlatformInstance.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def idcs_app(self):
        """
        Gets the idcs_app of this ApiPlatformInstance.

        :return: The idcs_app of this ApiPlatformInstance.
        :rtype: oci.api_platform.models.IdcsApp
        """
        return self._idcs_app

    @idcs_app.setter
    def idcs_app(self, idcs_app):
        """
        Sets the idcs_app of this ApiPlatformInstance.

        :param idcs_app: The idcs_app of this ApiPlatformInstance.
        :type: oci.api_platform.models.IdcsApp
        """
        self._idcs_app = idcs_app

    @property
    def uris(self):
        """
        Gets the uris of this ApiPlatformInstance.

        :return: The uris of this ApiPlatformInstance.
        :rtype: oci.api_platform.models.Uris
        """
        return self._uris

    @uris.setter
    def uris(self, uris):
        """
        Sets the uris of this ApiPlatformInstance.

        :param uris: The uris of this ApiPlatformInstance.
        :type: oci.api_platform.models.Uris
        """
        self._uris = uris

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ApiPlatformInstance.
        The date and time the instance was created, in the format defined by `RFC 3339`__

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ApiPlatformInstance.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ApiPlatformInstance.
        The date and time the instance was created, in the format defined by `RFC 3339`__

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ApiPlatformInstance.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ApiPlatformInstance.
        The date and time the instance was updated, in the format defined by `RFC 3339`__

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ApiPlatformInstance.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ApiPlatformInstance.
        The date and time the instance was updated, in the format defined by `RFC 3339`__

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ApiPlatformInstance.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ApiPlatformInstance.
        The current state of the instance

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ApiPlatformInstance.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ApiPlatformInstance.
        The current state of the instance


        :param lifecycle_state: The lifecycle_state of this ApiPlatformInstance.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ApiPlatformInstance.
        A message that describes the current state of the instance in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state


        :return: The lifecycle_details of this ApiPlatformInstance.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ApiPlatformInstance.
        A message that describes the current state of the instance in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state


        :param lifecycle_details: The lifecycle_details of this ApiPlatformInstance.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ApiPlatformInstance.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ApiPlatformInstance.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ApiPlatformInstance.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ApiPlatformInstance.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ApiPlatformInstance.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ApiPlatformInstance.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ApiPlatformInstance.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ApiPlatformInstance.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ApiPlatformInstance.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ApiPlatformInstance.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ApiPlatformInstance.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ApiPlatformInstance.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
