# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchTask(object):
    """
    A batch task contains common properties for all types of job tasks.
    """

    #: A constant which can be used with the type property of a BatchTask.
    #: This constant has a value of "COMPUTE"
    TYPE_COMPUTE = "COMPUTE"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "ACCEPTED"
    LIFECYCLE_STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "WAITING"
    LIFECYCLE_STATE_WAITING = "WAITING"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "CANCELING"
    LIFECYCLE_STATE_CANCELING = "CANCELING"

    #: A constant which can be used with the lifecycle_state property of a BatchTask.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new BatchTask object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.batch.models.ComputeTask`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BatchTask.
        :type id: str

        :param name:
            The value to assign to the name property of this BatchTask.
        :type name: str

        :param description:
            The value to assign to the description property of this BatchTask.
        :type description: str

        :param type:
            The value to assign to the type property of this BatchTask.
            Allowed values for this property are: "COMPUTE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BatchTask.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this BatchTask.
        :type lifecycle_details: str

        :param entitlement_claims:
            The value to assign to the entitlement_claims property of this BatchTask.
        :type entitlement_claims: list[str]

        :param dependencies:
            The value to assign to the dependencies property of this BatchTask.
        :type dependencies: list[str]

        :param environment_variables:
            The value to assign to the environment_variables property of this BatchTask.
        :type environment_variables: list[oci.batch.models.EnvironmentVariable]

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'entitlement_claims': 'list[str]',
            'dependencies': 'list[str]',
            'environment_variables': 'list[EnvironmentVariable]'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'entitlement_claims': 'entitlementClaims',
            'dependencies': 'dependencies',
            'environment_variables': 'environmentVariables'
        }
        self._id = None
        self._name = None
        self._description = None
        self._type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._entitlement_claims = None
        self._dependencies = None
        self._environment_variables = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'COMPUTE':
            return 'ComputeTask'
        else:
            return 'BatchTask'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BatchTask.
        The UUID of batch task.


        :return: The id of this BatchTask.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BatchTask.
        The UUID of batch task.


        :param id: The id of this BatchTask.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this BatchTask.
        The name of the batch task. It must be unique within its parent batch job.


        :return: The name of this BatchTask.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BatchTask.
        The name of the batch task. It must be unique within its parent batch job.


        :param name: The name of this BatchTask.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this BatchTask.
        An optional description that provides additional context next to the displayName.


        :return: The description of this BatchTask.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BatchTask.
        An optional description that provides additional context next to the displayName.


        :param description: The description of this BatchTask.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this BatchTask.
        Type of the batch task. Also serves as a discriminator for sub-entities.

        Allowed values for this property are: "COMPUTE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this BatchTask.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BatchTask.
        Type of the batch task. Also serves as a discriminator for sub-entities.


        :param type: The type of this BatchTask.
        :type: str
        """
        allowed_values = ["COMPUTE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this BatchTask.
        The current state of the batch task.

        Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this BatchTask.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this BatchTask.
        The current state of the batch task.


        :param lifecycle_state: The lifecycle_state of this BatchTask.
        :type: str
        """
        allowed_values = ["ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this BatchTask.
        A message that describes the current state of the batch task in more detail. For example, can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this BatchTask.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this BatchTask.
        A message that describes the current state of the batch task in more detail. For example, can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this BatchTask.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def entitlement_claims(self):
        """
        **[Required]** Gets the entitlement_claims of this BatchTask.
        A list of resources (for example licences) this task needs for its execution.


        :return: The entitlement_claims of this BatchTask.
        :rtype: list[str]
        """
        return self._entitlement_claims

    @entitlement_claims.setter
    def entitlement_claims(self, entitlement_claims):
        """
        Sets the entitlement_claims of this BatchTask.
        A list of resources (for example licences) this task needs for its execution.


        :param entitlement_claims: The entitlement_claims of this BatchTask.
        :type: list[str]
        """
        self._entitlement_claims = entitlement_claims

    @property
    def dependencies(self):
        """
        **[Required]** Gets the dependencies of this BatchTask.
        A list of tasks from the same job this task depends on referenced by name.


        :return: The dependencies of this BatchTask.
        :rtype: list[str]
        """
        return self._dependencies

    @dependencies.setter
    def dependencies(self, dependencies):
        """
        Sets the dependencies of this BatchTask.
        A list of tasks from the same job this task depends on referenced by name.


        :param dependencies: The dependencies of this BatchTask.
        :type: list[str]
        """
        self._dependencies = dependencies

    @property
    def environment_variables(self):
        """
        **[Required]** Gets the environment_variables of this BatchTask.
        Environment variables to use for the task execution.


        :return: The environment_variables of this BatchTask.
        :rtype: list[oci.batch.models.EnvironmentVariable]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this BatchTask.
        Environment variables to use for the task execution.


        :param environment_variables: The environment_variables of this BatchTask.
        :type: list[oci.batch.models.EnvironmentVariable]
        """
        self._environment_variables = environment_variables

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
