# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031

from .create_fleet_details import CreateFleetDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateServiceManagedFleetDetails(CreateFleetDetails):
    """
    Service managed Fleet configuration of the batch context.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateServiceManagedFleetDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.batch.models.CreateServiceManagedFleetDetails.type` attribute
        of this class is ``SERVICE_MANAGED_FLEET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CreateServiceManagedFleetDetails.
            Allowed values for this property are: "SERVICE_MANAGED_FLEET"
        :type type: str

        :param name:
            The value to assign to the name property of this CreateServiceManagedFleetDetails.
        :type name: str

        :param shape:
            The value to assign to the shape property of this CreateServiceManagedFleetDetails.
        :type shape: oci.batch.models.FleetShape

        :param max_concurrent_tasks:
            The value to assign to the max_concurrent_tasks property of this CreateServiceManagedFleetDetails.
        :type max_concurrent_tasks: int

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'shape': 'FleetShape',
            'max_concurrent_tasks': 'int'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'shape': 'shape',
            'max_concurrent_tasks': 'maxConcurrentTasks'
        }
        self._type = None
        self._name = None
        self._shape = None
        self._max_concurrent_tasks = None
        self._type = 'SERVICE_MANAGED_FLEET'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateServiceManagedFleetDetails.
        Name of the service managed fleet.


        :return: The name of this CreateServiceManagedFleetDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateServiceManagedFleetDetails.
        Name of the service managed fleet.


        :param name: The name of this CreateServiceManagedFleetDetails.
        :type: str
        """
        self._name = name

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this CreateServiceManagedFleetDetails.

        :return: The shape of this CreateServiceManagedFleetDetails.
        :rtype: oci.batch.models.FleetShape
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this CreateServiceManagedFleetDetails.

        :param shape: The shape of this CreateServiceManagedFleetDetails.
        :type: oci.batch.models.FleetShape
        """
        self._shape = shape

    @property
    def max_concurrent_tasks(self):
        """
        **[Required]** Gets the max_concurrent_tasks of this CreateServiceManagedFleetDetails.
        Maximum number of concurrent tasks for the service managed fleet.


        :return: The max_concurrent_tasks of this CreateServiceManagedFleetDetails.
        :rtype: int
        """
        return self._max_concurrent_tasks

    @max_concurrent_tasks.setter
    def max_concurrent_tasks(self, max_concurrent_tasks):
        """
        Sets the max_concurrent_tasks of this CreateServiceManagedFleetDetails.
        Maximum number of concurrent tasks for the service managed fleet.


        :param max_concurrent_tasks: The max_concurrent_tasks of this CreateServiceManagedFleetDetails.
        :type: int
        """
        self._max_concurrent_tasks = max_concurrent_tasks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
