# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031

from .batch_task_environment_volume import BatchTaskEnvironmentVolume
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NfsVolume(BatchTaskEnvironmentVolume):
    """
    A description of a NFS type of batch task environment volume.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NfsVolume object with values from keyword arguments. The default value of the :py:attr:`~oci.batch.models.NfsVolume.type` attribute
        of this class is ``NFS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this NfsVolume.
            Allowed values for this property are: "NFS"
        :type type: str

        :param name:
            The value to assign to the name property of this NfsVolume.
        :type name: str

        :param mount_target_fqdn:
            The value to assign to the mount_target_fqdn property of this NfsVolume.
        :type mount_target_fqdn: str

        :param mount_target_export_path:
            The value to assign to the mount_target_export_path property of this NfsVolume.
        :type mount_target_export_path: str

        :param local_mount_directory_path:
            The value to assign to the local_mount_directory_path property of this NfsVolume.
        :type local_mount_directory_path: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'mount_target_fqdn': 'str',
            'mount_target_export_path': 'str',
            'local_mount_directory_path': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'mount_target_fqdn': 'mountTargetFqdn',
            'mount_target_export_path': 'mountTargetExportPath',
            'local_mount_directory_path': 'localMountDirectoryPath'
        }
        self._type = None
        self._name = None
        self._mount_target_fqdn = None
        self._mount_target_export_path = None
        self._local_mount_directory_path = None
        self._type = 'NFS'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this NfsVolume.
        The name of the NfsVolume.


        :return: The name of this NfsVolume.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NfsVolume.
        The name of the NfsVolume.


        :param name: The name of this NfsVolume.
        :type: str
        """
        self._name = name

    @property
    def mount_target_fqdn(self):
        """
        **[Required]** Gets the mount_target_fqdn of this NfsVolume.
        The FQDN of the NFS server to connect to.


        :return: The mount_target_fqdn of this NfsVolume.
        :rtype: str
        """
        return self._mount_target_fqdn

    @mount_target_fqdn.setter
    def mount_target_fqdn(self, mount_target_fqdn):
        """
        Sets the mount_target_fqdn of this NfsVolume.
        The FQDN of the NFS server to connect to.


        :param mount_target_fqdn: The mount_target_fqdn of this NfsVolume.
        :type: str
        """
        self._mount_target_fqdn = mount_target_fqdn

    @property
    def mount_target_export_path(self):
        """
        **[Required]** Gets the mount_target_export_path of this NfsVolume.
        The path to the directory on the NFS server to be mounted.


        :return: The mount_target_export_path of this NfsVolume.
        :rtype: str
        """
        return self._mount_target_export_path

    @mount_target_export_path.setter
    def mount_target_export_path(self, mount_target_export_path):
        """
        Sets the mount_target_export_path of this NfsVolume.
        The path to the directory on the NFS server to be mounted.


        :param mount_target_export_path: The mount_target_export_path of this NfsVolume.
        :type: str
        """
        self._mount_target_export_path = mount_target_export_path

    @property
    def local_mount_directory_path(self):
        """
        **[Required]** Gets the local_mount_directory_path of this NfsVolume.
        The local path to mount the NFS share to.


        :return: The local_mount_directory_path of this NfsVolume.
        :rtype: str
        """
        return self._local_mount_directory_path

    @local_mount_directory_path.setter
    def local_mount_directory_path(self, local_mount_directory_path):
        """
        Sets the local_mount_directory_path of this NfsVolume.
        The local path to mount the NFS share to.


        :param local_mount_directory_path: The local_mount_directory_path of this NfsVolume.
        :type: str
        """
        self._local_mount_directory_path = local_mount_directory_path

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
