# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityContext(object):
    """
    Security context for container runtime configuration.

    See also `docs`__.

    __ https://docs.oracle.com/en-us/iaas/api/#/en/container-instances/20210415/datatypes/LinuxSecurityContext
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityContext object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param run_as_user:
            The value to assign to the run_as_user property of this SecurityContext.
        :type run_as_user: int

        :param run_as_group:
            The value to assign to the run_as_group property of this SecurityContext.
        :type run_as_group: int

        :param fs_group:
            The value to assign to the fs_group property of this SecurityContext.
        :type fs_group: int

        """
        self.swagger_types = {
            'run_as_user': 'int',
            'run_as_group': 'int',
            'fs_group': 'int'
        }
        self.attribute_map = {
            'run_as_user': 'runAsUser',
            'run_as_group': 'runAsGroup',
            'fs_group': 'fsGroup'
        }
        self._run_as_user = None
        self._run_as_group = None
        self._fs_group = None

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this SecurityContext.
        User ID for running processes inside the container.


        :return: The run_as_user of this SecurityContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this SecurityContext.
        User ID for running processes inside the container.


        :param run_as_user: The run_as_user of this SecurityContext.
        :type: int
        """
        self._run_as_user = run_as_user

    @property
    def run_as_group(self):
        """
        Gets the run_as_group of this SecurityContext.
        Group ID for running processes inside the container.


        :return: The run_as_group of this SecurityContext.
        :rtype: int
        """
        return self._run_as_group

    @run_as_group.setter
    def run_as_group(self, run_as_group):
        """
        Sets the run_as_group of this SecurityContext.
        Group ID for running processes inside the container.


        :param run_as_group: The run_as_group of this SecurityContext.
        :type: int
        """
        self._run_as_group = run_as_group

    @property
    def fs_group(self):
        """
        Gets the fs_group of this SecurityContext.
        A special supplemental group ID that applies to all containers in a pod.


        :return: The fs_group of this SecurityContext.
        :rtype: int
        """
        return self._fs_group

    @fs_group.setter
    def fs_group(self, fs_group):
        """
        Sets the fs_group of this SecurityContext.
        A special supplemental group ID that applies to all containers in a pod.


        :param fs_group: The fs_group of this SecurityContext.
        :type: int
        """
        self._fs_group = fs_group

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
