# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeGpuMemoryFabricSummary(object):
    """
    Summary information for a compute GPU memory fabric.
    """

    #: A constant which can be used with the firmware_update_state property of a ComputeGpuMemoryFabricSummary.
    #: This constant has a value of "WILL_UPDATE"
    FIRMWARE_UPDATE_STATE_WILL_UPDATE = "WILL_UPDATE"

    #: A constant which can be used with the firmware_update_state property of a ComputeGpuMemoryFabricSummary.
    #: This constant has a value of "NO_UPDATE"
    FIRMWARE_UPDATE_STATE_NO_UPDATE = "NO_UPDATE"

    #: A constant which can be used with the firmware_update_state property of a ComputeGpuMemoryFabricSummary.
    #: This constant has a value of "SKIP_RECYCLE_ENABLED"
    FIRMWARE_UPDATE_STATE_SKIP_RECYCLE_ENABLED = "SKIP_RECYCLE_ENABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeGpuMemoryFabricSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ComputeGpuMemoryFabricSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ComputeGpuMemoryFabricSummary.
        :type compartment_id: str

        :param compute_hpc_island_id:
            The value to assign to the compute_hpc_island_id property of this ComputeGpuMemoryFabricSummary.
        :type compute_hpc_island_id: str

        :param compute_network_block_id:
            The value to assign to the compute_network_block_id property of this ComputeGpuMemoryFabricSummary.
        :type compute_network_block_id: str

        :param compute_local_block_id:
            The value to assign to the compute_local_block_id property of this ComputeGpuMemoryFabricSummary.
        :type compute_local_block_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeGpuMemoryFabricSummary.
        :type lifecycle_state: str

        :param fabric_health:
            The value to assign to the fabric_health property of this ComputeGpuMemoryFabricSummary.
        :type fabric_health: str

        :param total_host_count:
            The value to assign to the total_host_count property of this ComputeGpuMemoryFabricSummary.
        :type total_host_count: int

        :param available_host_count:
            The value to assign to the available_host_count property of this ComputeGpuMemoryFabricSummary.
        :type available_host_count: int

        :param healthy_host_count:
            The value to assign to the healthy_host_count property of this ComputeGpuMemoryFabricSummary.
        :type healthy_host_count: int

        :param host_platform_name:
            The value to assign to the host_platform_name property of this ComputeGpuMemoryFabricSummary.
        :type host_platform_name: str

        :param switch_platform_name:
            The value to assign to the switch_platform_name property of this ComputeGpuMemoryFabricSummary.
        :type switch_platform_name: str

        :param current_firmware_bundle_id:
            The value to assign to the current_firmware_bundle_id property of this ComputeGpuMemoryFabricSummary.
        :type current_firmware_bundle_id: str

        :param target_firmware_bundle_id:
            The value to assign to the target_firmware_bundle_id property of this ComputeGpuMemoryFabricSummary.
        :type target_firmware_bundle_id: str

        :param firmware_update_state:
            The value to assign to the firmware_update_state property of this ComputeGpuMemoryFabricSummary.
            Allowed values for this property are: "WILL_UPDATE", "NO_UPDATE", "SKIP_RECYCLE_ENABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type firmware_update_state: str

        :param memory_fabric_preferences:
            The value to assign to the memory_fabric_preferences property of this ComputeGpuMemoryFabricSummary.
        :type memory_fabric_preferences: oci.core.models.MemoryFabricPreferencesDescriptor

        :param time_created:
            The value to assign to the time_created property of this ComputeGpuMemoryFabricSummary.
        :type time_created: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this ComputeGpuMemoryFabricSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ComputeGpuMemoryFabricSummary.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this ComputeGpuMemoryFabricSummary.
        :type system_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this ComputeGpuMemoryFabricSummary.
        :type display_name: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'compute_hpc_island_id': 'str',
            'compute_network_block_id': 'str',
            'compute_local_block_id': 'str',
            'lifecycle_state': 'str',
            'fabric_health': 'str',
            'total_host_count': 'int',
            'available_host_count': 'int',
            'healthy_host_count': 'int',
            'host_platform_name': 'str',
            'switch_platform_name': 'str',
            'current_firmware_bundle_id': 'str',
            'target_firmware_bundle_id': 'str',
            'firmware_update_state': 'str',
            'memory_fabric_preferences': 'MemoryFabricPreferencesDescriptor',
            'time_created': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))',
            'display_name': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'compute_hpc_island_id': 'computeHpcIslandId',
            'compute_network_block_id': 'computeNetworkBlockId',
            'compute_local_block_id': 'computeLocalBlockId',
            'lifecycle_state': 'lifecycleState',
            'fabric_health': 'fabricHealth',
            'total_host_count': 'totalHostCount',
            'available_host_count': 'availableHostCount',
            'healthy_host_count': 'healthyHostCount',
            'host_platform_name': 'hostPlatformName',
            'switch_platform_name': 'switchPlatformName',
            'current_firmware_bundle_id': 'currentFirmwareBundleId',
            'target_firmware_bundle_id': 'targetFirmwareBundleId',
            'firmware_update_state': 'firmwareUpdateState',
            'memory_fabric_preferences': 'memoryFabricPreferences',
            'time_created': 'timeCreated',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags',
            'display_name': 'displayName'
        }
        self._id = None
        self._compartment_id = None
        self._compute_hpc_island_id = None
        self._compute_network_block_id = None
        self._compute_local_block_id = None
        self._lifecycle_state = None
        self._fabric_health = None
        self._total_host_count = None
        self._available_host_count = None
        self._healthy_host_count = None
        self._host_platform_name = None
        self._switch_platform_name = None
        self._current_firmware_bundle_id = None
        self._target_firmware_bundle_id = None
        self._firmware_update_state = None
        self._memory_fabric_preferences = None
        self._time_created = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None
        self._display_name = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for the Customer-unique GPU memory fabric

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for the Customer-unique GPU memory fabric

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for the compartment. This should always be the
        root compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for the compartment. This should always be the
        root compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def compute_hpc_island_id(self):
        """
        **[Required]** Gets the compute_hpc_island_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for Customer-unique HPC Island

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_hpc_island_id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._compute_hpc_island_id

    @compute_hpc_island_id.setter
    def compute_hpc_island_id(self, compute_hpc_island_id):
        """
        Sets the compute_hpc_island_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for Customer-unique HPC Island

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_hpc_island_id: The compute_hpc_island_id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._compute_hpc_island_id = compute_hpc_island_id

    @property
    def compute_network_block_id(self):
        """
        **[Required]** Gets the compute_network_block_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for Customer-unique Network Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_network_block_id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._compute_network_block_id

    @compute_network_block_id.setter
    def compute_network_block_id(self, compute_network_block_id):
        """
        Sets the compute_network_block_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for Customer-unique Network Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_network_block_id: The compute_network_block_id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._compute_network_block_id = compute_network_block_id

    @property
    def compute_local_block_id(self):
        """
        **[Required]** Gets the compute_local_block_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for Customer-unique Local Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_local_block_id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._compute_local_block_id

    @compute_local_block_id.setter
    def compute_local_block_id(self, compute_local_block_id):
        """
        Sets the compute_local_block_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for Customer-unique Local Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_local_block_id: The compute_local_block_id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._compute_local_block_id = compute_local_block_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ComputeGpuMemoryFabricSummary.
        The lifecycle state of the GPU memory fabric


        :return: The lifecycle_state of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComputeGpuMemoryFabricSummary.
        The lifecycle state of the GPU memory fabric


        :param lifecycle_state: The lifecycle_state of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def fabric_health(self):
        """
        **[Required]** Gets the fabric_health of this ComputeGpuMemoryFabricSummary.
        The health state of the GPU memory fabric


        :return: The fabric_health of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._fabric_health

    @fabric_health.setter
    def fabric_health(self, fabric_health):
        """
        Sets the fabric_health of this ComputeGpuMemoryFabricSummary.
        The health state of the GPU memory fabric


        :param fabric_health: The fabric_health of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._fabric_health = fabric_health

    @property
    def total_host_count(self):
        """
        **[Required]** Gets the total_host_count of this ComputeGpuMemoryFabricSummary.
        The total number of bare metal hosts located in this compute GPU memory fabric.


        :return: The total_host_count of this ComputeGpuMemoryFabricSummary.
        :rtype: int
        """
        return self._total_host_count

    @total_host_count.setter
    def total_host_count(self, total_host_count):
        """
        Sets the total_host_count of this ComputeGpuMemoryFabricSummary.
        The total number of bare metal hosts located in this compute GPU memory fabric.


        :param total_host_count: The total_host_count of this ComputeGpuMemoryFabricSummary.
        :type: int
        """
        self._total_host_count = total_host_count

    @property
    def available_host_count(self):
        """
        Gets the available_host_count of this ComputeGpuMemoryFabricSummary.
        The total number of available bare metal hosts located in this compute GPU memory fabric.


        :return: The available_host_count of this ComputeGpuMemoryFabricSummary.
        :rtype: int
        """
        return self._available_host_count

    @available_host_count.setter
    def available_host_count(self, available_host_count):
        """
        Sets the available_host_count of this ComputeGpuMemoryFabricSummary.
        The total number of available bare metal hosts located in this compute GPU memory fabric.


        :param available_host_count: The available_host_count of this ComputeGpuMemoryFabricSummary.
        :type: int
        """
        self._available_host_count = available_host_count

    @property
    def healthy_host_count(self):
        """
        Gets the healthy_host_count of this ComputeGpuMemoryFabricSummary.
        The total number of healthy bare metal hosts located in this compute GPU memory fabric.


        :return: The healthy_host_count of this ComputeGpuMemoryFabricSummary.
        :rtype: int
        """
        return self._healthy_host_count

    @healthy_host_count.setter
    def healthy_host_count(self, healthy_host_count):
        """
        Sets the healthy_host_count of this ComputeGpuMemoryFabricSummary.
        The total number of healthy bare metal hosts located in this compute GPU memory fabric.


        :param healthy_host_count: The healthy_host_count of this ComputeGpuMemoryFabricSummary.
        :type: int
        """
        self._healthy_host_count = healthy_host_count

    @property
    def host_platform_name(self):
        """
        Gets the host_platform_name of this ComputeGpuMemoryFabricSummary.
        The host platform identifier used for bundle queries


        :return: The host_platform_name of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._host_platform_name

    @host_platform_name.setter
    def host_platform_name(self, host_platform_name):
        """
        Sets the host_platform_name of this ComputeGpuMemoryFabricSummary.
        The host platform identifier used for bundle queries


        :param host_platform_name: The host_platform_name of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._host_platform_name = host_platform_name

    @property
    def switch_platform_name(self):
        """
        Gets the switch_platform_name of this ComputeGpuMemoryFabricSummary.
        The switch platform identifier used for bundle queries


        :return: The switch_platform_name of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._switch_platform_name

    @switch_platform_name.setter
    def switch_platform_name(self, switch_platform_name):
        """
        Sets the switch_platform_name of this ComputeGpuMemoryFabricSummary.
        The switch platform identifier used for bundle queries


        :param switch_platform_name: The switch_platform_name of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._switch_platform_name = switch_platform_name

    @property
    def current_firmware_bundle_id(self):
        """
        Gets the current_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for current firmware bundle

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The current_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._current_firmware_bundle_id

    @current_firmware_bundle_id.setter
    def current_firmware_bundle_id(self, current_firmware_bundle_id):
        """
        Sets the current_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for current firmware bundle

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param current_firmware_bundle_id: The current_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._current_firmware_bundle_id = current_firmware_bundle_id

    @property
    def target_firmware_bundle_id(self):
        """
        Gets the target_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for targeted firmware bundle

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The target_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._target_firmware_bundle_id

    @target_firmware_bundle_id.setter
    def target_firmware_bundle_id(self, target_firmware_bundle_id):
        """
        Sets the target_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        The `OCID`__ for targeted firmware bundle

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param target_firmware_bundle_id: The target_firmware_bundle_id of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._target_firmware_bundle_id = target_firmware_bundle_id

    @property
    def firmware_update_state(self):
        """
        Gets the firmware_update_state of this ComputeGpuMemoryFabricSummary.
        The state of Memory Fabric Firmware update

        Allowed values for this property are: "WILL_UPDATE", "NO_UPDATE", "SKIP_RECYCLE_ENABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The firmware_update_state of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._firmware_update_state

    @firmware_update_state.setter
    def firmware_update_state(self, firmware_update_state):
        """
        Sets the firmware_update_state of this ComputeGpuMemoryFabricSummary.
        The state of Memory Fabric Firmware update


        :param firmware_update_state: The firmware_update_state of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        allowed_values = ["WILL_UPDATE", "NO_UPDATE", "SKIP_RECYCLE_ENABLED"]
        if not value_allowed_none_or_none_sentinel(firmware_update_state, allowed_values):
            firmware_update_state = 'UNKNOWN_ENUM_VALUE'
        self._firmware_update_state = firmware_update_state

    @property
    def memory_fabric_preferences(self):
        """
        Gets the memory_fabric_preferences of this ComputeGpuMemoryFabricSummary.

        :return: The memory_fabric_preferences of this ComputeGpuMemoryFabricSummary.
        :rtype: oci.core.models.MemoryFabricPreferencesDescriptor
        """
        return self._memory_fabric_preferences

    @memory_fabric_preferences.setter
    def memory_fabric_preferences(self, memory_fabric_preferences):
        """
        Sets the memory_fabric_preferences of this ComputeGpuMemoryFabricSummary.

        :param memory_fabric_preferences: The memory_fabric_preferences of this ComputeGpuMemoryFabricSummary.
        :type: oci.core.models.MemoryFabricPreferencesDescriptor
        """
        self._memory_fabric_preferences = memory_fabric_preferences

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ComputeGpuMemoryFabricSummary.
        The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339]
        (https://tools.ietf.org/html/rfc3339).

        Example: `2016-08-25T21:10:29.600Z`


        :return: The time_created of this ComputeGpuMemoryFabricSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComputeGpuMemoryFabricSummary.
        The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339]
        (https://tools.ietf.org/html/rfc3339).

        Example: `2016-08-25T21:10:29.600Z`


        :param time_created: The time_created of this ComputeGpuMemoryFabricSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ComputeGpuMemoryFabricSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ComputeGpuMemoryFabricSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ComputeGpuMemoryFabricSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ComputeGpuMemoryFabricSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ComputeGpuMemoryFabricSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ComputeGpuMemoryFabricSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ComputeGpuMemoryFabricSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ComputeGpuMemoryFabricSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ComputeGpuMemoryFabricSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :return: The system_tags of this ComputeGpuMemoryFabricSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ComputeGpuMemoryFabricSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :param system_tags: The system_tags of this ComputeGpuMemoryFabricSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this ComputeGpuMemoryFabricSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this ComputeGpuMemoryFabricSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ComputeGpuMemoryFabricSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this ComputeGpuMemoryFabricSummary.
        :type: str
        """
        self._display_name = display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
