# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportObjectMetadataSummary(object):
    """
    Details of the exported object
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportObjectMetadataSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this ExportObjectMetadataSummary.
        :type key: str

        :param name:
            The value to assign to the name property of this ExportObjectMetadataSummary.
        :type name: str

        :param identifier:
            The value to assign to the identifier property of this ExportObjectMetadataSummary.
        :type identifier: str

        :param object_type:
            The value to assign to the object_type property of this ExportObjectMetadataSummary.
        :type object_type: str

        :param object_version:
            The value to assign to the object_version property of this ExportObjectMetadataSummary.
        :type object_version: str

        :param aggregator_key:
            The value to assign to the aggregator_key property of this ExportObjectMetadataSummary.
        :type aggregator_key: str

        :param name_path:
            The value to assign to the name_path property of this ExportObjectMetadataSummary.
        :type name_path: str

        :param time_updated_in_millis:
            The value to assign to the time_updated_in_millis property of this ExportObjectMetadataSummary.
        :type time_updated_in_millis: int

        """
        self.swagger_types = {
            'key': 'str',
            'name': 'str',
            'identifier': 'str',
            'object_type': 'str',
            'object_version': 'str',
            'aggregator_key': 'str',
            'name_path': 'str',
            'time_updated_in_millis': 'int'
        }
        self.attribute_map = {
            'key': 'key',
            'name': 'name',
            'identifier': 'identifier',
            'object_type': 'objectType',
            'object_version': 'objectVersion',
            'aggregator_key': 'aggregatorKey',
            'name_path': 'namePath',
            'time_updated_in_millis': 'timeUpdatedInMillis'
        }
        self._key = None
        self._name = None
        self._identifier = None
        self._object_type = None
        self._object_version = None
        self._aggregator_key = None
        self._name_path = None
        self._time_updated_in_millis = None

    @property
    def key(self):
        """
        Gets the key of this ExportObjectMetadataSummary.
        Key of the object


        :return: The key of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this ExportObjectMetadataSummary.
        Key of the object


        :param key: The key of this ExportObjectMetadataSummary.
        :type: str
        """
        self._key = key

    @property
    def name(self):
        """
        Gets the name of this ExportObjectMetadataSummary.
        Name of the object


        :return: The name of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExportObjectMetadataSummary.
        Name of the object


        :param name: The name of this ExportObjectMetadataSummary.
        :type: str
        """
        self._name = name

    @property
    def identifier(self):
        """
        Gets the identifier of this ExportObjectMetadataSummary.
        Object identifier


        :return: The identifier of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """
        Sets the identifier of this ExportObjectMetadataSummary.
        Object identifier


        :param identifier: The identifier of this ExportObjectMetadataSummary.
        :type: str
        """
        self._identifier = identifier

    @property
    def object_type(self):
        """
        Gets the object_type of this ExportObjectMetadataSummary.
        Object type


        :return: The object_type of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._object_type

    @object_type.setter
    def object_type(self, object_type):
        """
        Sets the object_type of this ExportObjectMetadataSummary.
        Object type


        :param object_type: The object_type of this ExportObjectMetadataSummary.
        :type: str
        """
        self._object_type = object_type

    @property
    def object_version(self):
        """
        Gets the object_version of this ExportObjectMetadataSummary.
        Object version


        :return: The object_version of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._object_version

    @object_version.setter
    def object_version(self, object_version):
        """
        Sets the object_version of this ExportObjectMetadataSummary.
        Object version


        :param object_version: The object_version of this ExportObjectMetadataSummary.
        :type: str
        """
        self._object_version = object_version

    @property
    def aggregator_key(self):
        """
        Gets the aggregator_key of this ExportObjectMetadataSummary.
        Aggregator key


        :return: The aggregator_key of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._aggregator_key

    @aggregator_key.setter
    def aggregator_key(self, aggregator_key):
        """
        Sets the aggregator_key of this ExportObjectMetadataSummary.
        Aggregator key


        :param aggregator_key: The aggregator_key of this ExportObjectMetadataSummary.
        :type: str
        """
        self._aggregator_key = aggregator_key

    @property
    def name_path(self):
        """
        Gets the name_path of this ExportObjectMetadataSummary.
        Object name path


        :return: The name_path of this ExportObjectMetadataSummary.
        :rtype: str
        """
        return self._name_path

    @name_path.setter
    def name_path(self, name_path):
        """
        Sets the name_path of this ExportObjectMetadataSummary.
        Object name path


        :param name_path: The name_path of this ExportObjectMetadataSummary.
        :type: str
        """
        self._name_path = name_path

    @property
    def time_updated_in_millis(self):
        """
        Gets the time_updated_in_millis of this ExportObjectMetadataSummary.
        time at which this object was last updated.


        :return: The time_updated_in_millis of this ExportObjectMetadataSummary.
        :rtype: int
        """
        return self._time_updated_in_millis

    @time_updated_in_millis.setter
    def time_updated_in_millis(self, time_updated_in_millis):
        """
        Sets the time_updated_in_millis of this ExportObjectMetadataSummary.
        time at which this object was last updated.


        :param time_updated_in_millis: The time_updated_in_millis of this ExportObjectMetadataSummary.
        :type: int
        """
        self._time_updated_in_millis = time_updated_in_millis

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
