# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityFeatureAnalyticsDimensions(object):
    """
    The scope of analytics data.
    """

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "UNIFIED_AUDIT"
    SECURITY_FEATURE_UNIFIED_AUDIT = "UNIFIED_AUDIT"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "FINE_GRAINED_AUDIT"
    SECURITY_FEATURE_FINE_GRAINED_AUDIT = "FINE_GRAINED_AUDIT"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "TRADITIONAL_AUDIT"
    SECURITY_FEATURE_TRADITIONAL_AUDIT = "TRADITIONAL_AUDIT"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "DATABASE_VAULT"
    SECURITY_FEATURE_DATABASE_VAULT = "DATABASE_VAULT"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "PRIVILEGE_ANALYSIS"
    SECURITY_FEATURE_PRIVILEGE_ANALYSIS = "PRIVILEGE_ANALYSIS"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "TABLESPACE_ENCRYPTION"
    SECURITY_FEATURE_TABLESPACE_ENCRYPTION = "TABLESPACE_ENCRYPTION"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "COLUMN_ENCRYPTION"
    SECURITY_FEATURE_COLUMN_ENCRYPTION = "COLUMN_ENCRYPTION"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "NETWORK_ENCRYPTION"
    SECURITY_FEATURE_NETWORK_ENCRYPTION = "NETWORK_ENCRYPTION"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "PASSWORD_AUTHENTICATION"
    SECURITY_FEATURE_PASSWORD_AUTHENTICATION = "PASSWORD_AUTHENTICATION"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "GLOBAL_AUTHENTICATION"
    SECURITY_FEATURE_GLOBAL_AUTHENTICATION = "GLOBAL_AUTHENTICATION"

    #: A constant which can be used with the security_feature property of a SecurityFeatureAnalyticsDimensions.
    #: This constant has a value of "EXTERNAL_AUTHENTICATION"
    SECURITY_FEATURE_EXTERNAL_AUTHENTICATION = "EXTERNAL_AUTHENTICATION"

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityFeatureAnalyticsDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param security_feature:
            The value to assign to the security_feature property of this SecurityFeatureAnalyticsDimensions.
            Allowed values for this property are: "UNIFIED_AUDIT", "FINE_GRAINED_AUDIT", "TRADITIONAL_AUDIT", "DATABASE_VAULT", "PRIVILEGE_ANALYSIS", "TABLESPACE_ENCRYPTION", "COLUMN_ENCRYPTION", "NETWORK_ENCRYPTION", "PASSWORD_AUTHENTICATION", "GLOBAL_AUTHENTICATION", "EXTERNAL_AUTHENTICATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type security_feature: str

        """
        self.swagger_types = {
            'security_feature': 'str'
        }
        self.attribute_map = {
            'security_feature': 'securityFeature'
        }
        self._security_feature = None

    @property
    def security_feature(self):
        """
        Gets the security_feature of this SecurityFeatureAnalyticsDimensions.
        The name of the security feature.

        Allowed values for this property are: "UNIFIED_AUDIT", "FINE_GRAINED_AUDIT", "TRADITIONAL_AUDIT", "DATABASE_VAULT", "PRIVILEGE_ANALYSIS", "TABLESPACE_ENCRYPTION", "COLUMN_ENCRYPTION", "NETWORK_ENCRYPTION", "PASSWORD_AUTHENTICATION", "GLOBAL_AUTHENTICATION", "EXTERNAL_AUTHENTICATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The security_feature of this SecurityFeatureAnalyticsDimensions.
        :rtype: str
        """
        return self._security_feature

    @security_feature.setter
    def security_feature(self, security_feature):
        """
        Sets the security_feature of this SecurityFeatureAnalyticsDimensions.
        The name of the security feature.


        :param security_feature: The security_feature of this SecurityFeatureAnalyticsDimensions.
        :type: str
        """
        allowed_values = ["UNIFIED_AUDIT", "FINE_GRAINED_AUDIT", "TRADITIONAL_AUDIT", "DATABASE_VAULT", "PRIVILEGE_ANALYSIS", "TABLESPACE_ENCRYPTION", "COLUMN_ENCRYPTION", "NETWORK_ENCRYPTION", "PASSWORD_AUTHENTICATION", "GLOBAL_AUTHENTICATION", "EXTERNAL_AUTHENTICATION"]
        if not value_allowed_none_or_none_sentinel(security_feature, allowed_values):
            security_feature = 'UNKNOWN_ENUM_VALUE'
        self._security_feature = security_feature

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
