# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentityConnectorDetails(object):
    """
    Details of the identity connector
    """

    #: A constant which can be used with the cloud_provider property of a IdentityConnectorDetails.
    #: This constant has a value of "AZURE"
    CLOUD_PROVIDER_AZURE = "AZURE"

    #: A constant which can be used with the cloud_provider property of a IdentityConnectorDetails.
    #: This constant has a value of "GCP"
    CLOUD_PROVIDER_GCP = "GCP"

    #: A constant which can be used with the cloud_provider property of a IdentityConnectorDetails.
    #: This constant has a value of "AWS"
    CLOUD_PROVIDER_AWS = "AWS"

    def __init__(self, **kwargs):
        """
        Initializes a new IdentityConnectorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this IdentityConnectorDetails.
        :type id: str

        :param cloud_provider:
            The value to assign to the cloud_provider property of this IdentityConnectorDetails.
            Allowed values for this property are: "AZURE", "GCP", "AWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cloud_provider: str

        """
        self.swagger_types = {
            'id': 'str',
            'cloud_provider': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'cloud_provider': 'cloudProvider'
        }
        self._id = None
        self._cloud_provider = None

    @property
    def id(self):
        """
        Gets the id of this IdentityConnectorDetails.
        The OCID of the identity connector


        :return: The id of this IdentityConnectorDetails.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IdentityConnectorDetails.
        The OCID of the identity connector


        :param id: The id of this IdentityConnectorDetails.
        :type: str
        """
        self._id = id

    @property
    def cloud_provider(self):
        """
        Gets the cloud_provider of this IdentityConnectorDetails.
        Cloud provider

        Allowed values for this property are: "AZURE", "GCP", "AWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cloud_provider of this IdentityConnectorDetails.
        :rtype: str
        """
        return self._cloud_provider

    @cloud_provider.setter
    def cloud_provider(self, cloud_provider):
        """
        Sets the cloud_provider of this IdentityConnectorDetails.
        Cloud provider


        :param cloud_provider: The cloud_provider of this IdentityConnectorDetails.
        :type: str
        """
        allowed_values = ["AZURE", "GCP", "AWS"]
        if not value_allowed_none_or_none_sentinel(cloud_provider, allowed_values):
            cloud_provider = 'UNKNOWN_ENUM_VALUE'
        self._cloud_provider = cloud_provider

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
