# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseFleetHaOverviewMetrics(object):
    """
    The details of the HA metrics for the fleet of databases.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseFleetHaOverviewMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ha_metrics:
            The value to assign to the ha_metrics property of this DatabaseFleetHaOverviewMetrics.
        :type ha_metrics: list[oci.database_management.models.DatabaseHaMetrics]

        """
        self.swagger_types = {
            'ha_metrics': 'list[DatabaseHaMetrics]'
        }
        self.attribute_map = {
            'ha_metrics': 'haMetrics'
        }
        self._ha_metrics = None

    @property
    def ha_metrics(self):
        """
        **[Required]** Gets the ha_metrics of this DatabaseFleetHaOverviewMetrics.
        A list of the databases present in the fleet and their HA usage metrics.


        :return: The ha_metrics of this DatabaseFleetHaOverviewMetrics.
        :rtype: list[oci.database_management.models.DatabaseHaMetrics]
        """
        return self._ha_metrics

    @ha_metrics.setter
    def ha_metrics(self, ha_metrics):
        """
        Sets the ha_metrics of this DatabaseFleetHaOverviewMetrics.
        A list of the databases present in the fleet and their HA usage metrics.


        :param ha_metrics: The ha_metrics of this DatabaseFleetHaOverviewMetrics.
        :type: list[oci.database_management.models.DatabaseHaMetrics]
        """
        self._ha_metrics = ha_metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
