# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlApplyErrorWorker(object):
    """
    If the replica is multi-threaded, error from worker threads. Otherwise, error from the applier thread.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlApplyErrorWorker object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param last_error_number:
            The value to assign to the last_error_number property of this MySqlApplyErrorWorker.
        :type last_error_number: int

        :param last_error_message:
            The value to assign to the last_error_message property of this MySqlApplyErrorWorker.
        :type last_error_message: str

        :param time_last_error:
            The value to assign to the time_last_error property of this MySqlApplyErrorWorker.
        :type time_last_error: datetime

        """
        self.swagger_types = {
            'last_error_number': 'int',
            'last_error_message': 'str',
            'time_last_error': 'datetime'
        }
        self.attribute_map = {
            'last_error_number': 'lastErrorNumber',
            'last_error_message': 'lastErrorMessage',
            'time_last_error': 'timeLastError'
        }
        self._last_error_number = None
        self._last_error_message = None
        self._time_last_error = None

    @property
    def last_error_number(self):
        """
        **[Required]** Gets the last_error_number of this MySqlApplyErrorWorker.
        The error number of the most recent error that caused the worker thread to stop.


        :return: The last_error_number of this MySqlApplyErrorWorker.
        :rtype: int
        """
        return self._last_error_number

    @last_error_number.setter
    def last_error_number(self, last_error_number):
        """
        Sets the last_error_number of this MySqlApplyErrorWorker.
        The error number of the most recent error that caused the worker thread to stop.


        :param last_error_number: The last_error_number of this MySqlApplyErrorWorker.
        :type: int
        """
        self._last_error_number = last_error_number

    @property
    def last_error_message(self):
        """
        **[Required]** Gets the last_error_message of this MySqlApplyErrorWorker.
        The error message of the most recent error that caused the worker thread to stop.


        :return: The last_error_message of this MySqlApplyErrorWorker.
        :rtype: str
        """
        return self._last_error_message

    @last_error_message.setter
    def last_error_message(self, last_error_message):
        """
        Sets the last_error_message of this MySqlApplyErrorWorker.
        The error message of the most recent error that caused the worker thread to stop.


        :param last_error_message: The last_error_message of this MySqlApplyErrorWorker.
        :type: str
        """
        self._last_error_message = last_error_message

    @property
    def time_last_error(self):
        """
        **[Required]** Gets the time_last_error of this MySqlApplyErrorWorker.
        The timestamp when the most recent worker error occurred.


        :return: The time_last_error of this MySqlApplyErrorWorker.
        :rtype: datetime
        """
        return self._time_last_error

    @time_last_error.setter
    def time_last_error(self, time_last_error):
        """
        Sets the time_last_error of this MySqlApplyErrorWorker.
        The timestamp when the most recent worker error occurred.


        :param time_last_error: The time_last_error of this MySqlApplyErrorWorker.
        :type: datetime
        """
        self._time_last_error = time_last_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
