# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlDigestErrorSummary(object):
    """
    Consists of the error and the number of times it is encountered.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlDigestErrorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param error:
            The value to assign to the error property of this MySqlDigestErrorSummary.
        :type error: oci.database_management.models.MySqlQueryMessage

        :param occurrence_count:
            The value to assign to the occurrence_count property of this MySqlDigestErrorSummary.
        :type occurrence_count: int

        """
        self.swagger_types = {
            'error': 'MySqlQueryMessage',
            'occurrence_count': 'int'
        }
        self.attribute_map = {
            'error': 'error',
            'occurrence_count': 'occurrenceCount'
        }
        self._error = None
        self._occurrence_count = None

    @property
    def error(self):
        """
        **[Required]** Gets the error of this MySqlDigestErrorSummary.

        :return: The error of this MySqlDigestErrorSummary.
        :rtype: oci.database_management.models.MySqlQueryMessage
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this MySqlDigestErrorSummary.

        :param error: The error of this MySqlDigestErrorSummary.
        :type: oci.database_management.models.MySqlQueryMessage
        """
        self._error = error

    @property
    def occurrence_count(self):
        """
        **[Required]** Gets the occurrence_count of this MySqlDigestErrorSummary.
        The number of times a MySQL error is encountered.


        :return: The occurrence_count of this MySqlDigestErrorSummary.
        :rtype: int
        """
        return self._occurrence_count

    @occurrence_count.setter
    def occurrence_count(self, occurrence_count):
        """
        Sets the occurrence_count of this MySqlDigestErrorSummary.
        The number of times a MySQL error is encountered.


        :param occurrence_count: The occurrence_count of this MySqlDigestErrorSummary.
        :type: int
        """
        self._occurrence_count = occurrence_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
