# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlQueryDetails(object):
    """
    The details of a given MySQL query, it consists of the query sample details, the explain plan and potential warnings.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlQueryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param query_sample_details:
            The value to assign to the query_sample_details property of this MySqlQueryDetails.
        :type query_sample_details: oci.database_management.models.MySqlQuerySampleDetails

        :param query_explain_plan:
            The value to assign to the query_explain_plan property of this MySqlQueryDetails.
        :type query_explain_plan: oci.database_management.models.MySqlQueryExplainPlan

        :param query_messages:
            The value to assign to the query_messages property of this MySqlQueryDetails.
        :type query_messages: list[oci.database_management.models.MySqlQueryMessage]

        """
        self.swagger_types = {
            'query_sample_details': 'MySqlQuerySampleDetails',
            'query_explain_plan': 'MySqlQueryExplainPlan',
            'query_messages': 'list[MySqlQueryMessage]'
        }
        self.attribute_map = {
            'query_sample_details': 'querySampleDetails',
            'query_explain_plan': 'queryExplainPlan',
            'query_messages': 'queryMessages'
        }
        self._query_sample_details = None
        self._query_explain_plan = None
        self._query_messages = None

    @property
    def query_sample_details(self):
        """
        **[Required]** Gets the query_sample_details of this MySqlQueryDetails.

        :return: The query_sample_details of this MySqlQueryDetails.
        :rtype: oci.database_management.models.MySqlQuerySampleDetails
        """
        return self._query_sample_details

    @query_sample_details.setter
    def query_sample_details(self, query_sample_details):
        """
        Sets the query_sample_details of this MySqlQueryDetails.

        :param query_sample_details: The query_sample_details of this MySqlQueryDetails.
        :type: oci.database_management.models.MySqlQuerySampleDetails
        """
        self._query_sample_details = query_sample_details

    @property
    def query_explain_plan(self):
        """
        Gets the query_explain_plan of this MySqlQueryDetails.

        :return: The query_explain_plan of this MySqlQueryDetails.
        :rtype: oci.database_management.models.MySqlQueryExplainPlan
        """
        return self._query_explain_plan

    @query_explain_plan.setter
    def query_explain_plan(self, query_explain_plan):
        """
        Sets the query_explain_plan of this MySqlQueryDetails.

        :param query_explain_plan: The query_explain_plan of this MySqlQueryDetails.
        :type: oci.database_management.models.MySqlQueryExplainPlan
        """
        self._query_explain_plan = query_explain_plan

    @property
    def query_messages(self):
        """
        Gets the query_messages of this MySqlQueryDetails.
        The errors, warnings and notes that could be raised by the execution of the query.


        :return: The query_messages of this MySqlQueryDetails.
        :rtype: list[oci.database_management.models.MySqlQueryMessage]
        """
        return self._query_messages

    @query_messages.setter
    def query_messages(self, query_messages):
        """
        Sets the query_messages of this MySqlQueryDetails.
        The errors, warnings and notes that could be raised by the execution of the query.


        :param query_messages: The query_messages of this MySqlQueryDetails.
        :type: list[oci.database_management.models.MySqlQueryMessage]
        """
        self._query_messages = query_messages

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
