# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenAiUpdateDetail(object):
    """
    Details required for existing GenAi instance to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenAiUpdateDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this GenAiUpdateDetail.
        :type instance_id: str

        :param unit_count:
            The value to assign to the unit_count property of this GenAiUpdateDetail.
        :type unit_count: int

        :param endpoints:
            The value to assign to the endpoints property of this GenAiUpdateDetail.
        :type endpoints: list[oci.dif.models.EndpointDetails]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'unit_count': 'int',
            'endpoints': 'list[EndpointDetails]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'unit_count': 'unitCount',
            'endpoints': 'endpoints'
        }
        self._instance_id = None
        self._unit_count = None
        self._endpoints = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this GenAiUpdateDetail.
        Instance id of the exisitng GenAi instance to be updated.


        :return: The instance_id of this GenAiUpdateDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this GenAiUpdateDetail.
        Instance id of the exisitng GenAi instance to be updated.


        :param instance_id: The instance_id of this GenAiUpdateDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def unit_count(self):
        """
        Gets the unit_count of this GenAiUpdateDetail.
        No of replicas of base model to be used for hosting.


        :return: The unit_count of this GenAiUpdateDetail.
        :rtype: int
        """
        return self._unit_count

    @unit_count.setter
    def unit_count(self, unit_count):
        """
        Sets the unit_count of this GenAiUpdateDetail.
        No of replicas of base model to be used for hosting.


        :param unit_count: The unit_count of this GenAiUpdateDetail.
        :type: int
        """
        self._unit_count = unit_count

    @property
    def endpoints(self):
        """
        Gets the endpoints of this GenAiUpdateDetail.
        List of endpoints to be provisioned new or updated if existing for the GenAi dedicated cluster.


        :return: The endpoints of this GenAiUpdateDetail.
        :rtype: list[oci.dif.models.EndpointDetails]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """
        Sets the endpoints of this GenAiUpdateDetail.
        List of endpoints to be provisioned new or updated if existing for the GenAi dedicated cluster.


        :param endpoints: The endpoints of this GenAiUpdateDetail.
        :type: list[oci.dif.models.EndpointDetails]
        """
        self._endpoints = endpoints

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
