# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutomaticDrConfigurationSummary(object):
    """
    The summary of an Automatic DR configuration.
    """

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_sub_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "RESOURCE_PRINCIPAL_VALIDATION_FAILED"
    LIFECYCLE_SUB_STATE_RESOURCE_PRINCIPAL_VALIDATION_FAILED = "RESOURCE_PRINCIPAL_VALIDATION_FAILED"

    #: A constant which can be used with the lifecycle_sub_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "DR_PLAN_NEEDS_ATTENTION"
    LIFECYCLE_SUB_STATE_DR_PLAN_NEEDS_ATTENTION = "DR_PLAN_NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_sub_state property of a AutomaticDrConfigurationSummary.
    #: This constant has a value of "DR_PLAN_INACTIVE"
    LIFECYCLE_SUB_STATE_DR_PLAN_INACTIVE = "DR_PLAN_INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new AutomaticDrConfigurationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AutomaticDrConfigurationSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this AutomaticDrConfigurationSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AutomaticDrConfigurationSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this AutomaticDrConfigurationSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AutomaticDrConfigurationSummary.
        :type time_updated: datetime

        :param dr_protection_group_id:
            The value to assign to the dr_protection_group_id property of this AutomaticDrConfigurationSummary.
        :type dr_protection_group_id: str

        :param default_switchover_dr_plan_id:
            The value to assign to the default_switchover_dr_plan_id property of this AutomaticDrConfigurationSummary.
        :type default_switchover_dr_plan_id: str

        :param default_failover_dr_plan_id:
            The value to assign to the default_failover_dr_plan_id property of this AutomaticDrConfigurationSummary.
        :type default_failover_dr_plan_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AutomaticDrConfigurationSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_sub_state:
            The value to assign to the lifecycle_sub_state property of this AutomaticDrConfigurationSummary.
            Allowed values for this property are: "RESOURCE_PRINCIPAL_VALIDATION_FAILED", "DR_PLAN_NEEDS_ATTENTION", "DR_PLAN_INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_sub_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AutomaticDrConfigurationSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AutomaticDrConfigurationSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AutomaticDrConfigurationSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AutomaticDrConfigurationSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'dr_protection_group_id': 'str',
            'default_switchover_dr_plan_id': 'str',
            'default_failover_dr_plan_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_sub_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'dr_protection_group_id': 'drProtectionGroupId',
            'default_switchover_dr_plan_id': 'defaultSwitchoverDrPlanId',
            'default_failover_dr_plan_id': 'defaultFailoverDrPlanId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_sub_state': 'lifecycleSubState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._dr_protection_group_id = None
        self._default_switchover_dr_plan_id = None
        self._default_failover_dr_plan_id = None
        self._lifecycle_state = None
        self._lifecycle_sub_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AutomaticDrConfigurationSummary.
        The OCID of the Automatic DR configuration.

        Example: `ocid1.automaticdrconfiguration.oc1..uniqueID`


        :return: The id of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AutomaticDrConfigurationSummary.
        The OCID of the Automatic DR configuration.

        Example: `ocid1.automaticdrconfiguration.oc1..uniqueID`


        :param id: The id of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AutomaticDrConfigurationSummary.
        The display name of the Automatic DR configuration.


        :return: The display_name of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AutomaticDrConfigurationSummary.
        The display name of the Automatic DR configuration.


        :param display_name: The display_name of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AutomaticDrConfigurationSummary.
        The OCID of the compartment containing the Automatic DR configuration.

        Example: `ocid1.compartment.oc1..uniqueID`


        :return: The compartment_id of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AutomaticDrConfigurationSummary.
        The OCID of the compartment containing the Automatic DR configuration.

        Example: `ocid1.compartment.oc1..uniqueID`


        :param compartment_id: The compartment_id of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AutomaticDrConfigurationSummary.
        The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.

        Example: `2024-03-29T09:36:42Z`


        :return: The time_created of this AutomaticDrConfigurationSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AutomaticDrConfigurationSummary.
        The date and time the Automatic DR configuration was created. An RFC3339 formatted datetime string.

        Example: `2024-03-29T09:36:42Z`


        :param time_created: The time_created of this AutomaticDrConfigurationSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this AutomaticDrConfigurationSummary.
        The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.

        Example: `2024-03-29T09:36:42Z`


        :return: The time_updated of this AutomaticDrConfigurationSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AutomaticDrConfigurationSummary.
        The date and time the Automatic DR configuration was updated. An RFC3339 formatted datetime string.

        Example: `2024-03-29T09:36:42Z`


        :param time_updated: The time_updated of this AutomaticDrConfigurationSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def dr_protection_group_id(self):
        """
        **[Required]** Gets the dr_protection_group_id of this AutomaticDrConfigurationSummary.
        The OCID of the DR protection group to which this Automatic DR configuration belongs.

        Example: `ocid1.drprotectiongroup.oc1..uniqueID`


        :return: The dr_protection_group_id of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._dr_protection_group_id

    @dr_protection_group_id.setter
    def dr_protection_group_id(self, dr_protection_group_id):
        """
        Sets the dr_protection_group_id of this AutomaticDrConfigurationSummary.
        The OCID of the DR protection group to which this Automatic DR configuration belongs.

        Example: `ocid1.drprotectiongroup.oc1..uniqueID`


        :param dr_protection_group_id: The dr_protection_group_id of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._dr_protection_group_id = dr_protection_group_id

    @property
    def default_switchover_dr_plan_id(self):
        """
        Gets the default_switchover_dr_plan_id of this AutomaticDrConfigurationSummary.
        The unique id of a Switchover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :return: The default_switchover_dr_plan_id of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._default_switchover_dr_plan_id

    @default_switchover_dr_plan_id.setter
    def default_switchover_dr_plan_id(self, default_switchover_dr_plan_id):
        """
        Sets the default_switchover_dr_plan_id of this AutomaticDrConfigurationSummary.
        The unique id of a Switchover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :param default_switchover_dr_plan_id: The default_switchover_dr_plan_id of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._default_switchover_dr_plan_id = default_switchover_dr_plan_id

    @property
    def default_failover_dr_plan_id(self):
        """
        Gets the default_failover_dr_plan_id of this AutomaticDrConfigurationSummary.
        The unique id of a Failover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :return: The default_failover_dr_plan_id of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._default_failover_dr_plan_id

    @default_failover_dr_plan_id.setter
    def default_failover_dr_plan_id(self, default_failover_dr_plan_id):
        """
        Sets the default_failover_dr_plan_id of this AutomaticDrConfigurationSummary.
        The unique id of a Failover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :param default_failover_dr_plan_id: The default_failover_dr_plan_id of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._default_failover_dr_plan_id = default_failover_dr_plan_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AutomaticDrConfigurationSummary.
        The current state of the Automatic DR configuration.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AutomaticDrConfigurationSummary.
        The current state of the Automatic DR configuration.


        :param lifecycle_state: The lifecycle_state of this AutomaticDrConfigurationSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_sub_state(self):
        """
        Gets the lifecycle_sub_state of this AutomaticDrConfigurationSummary.
        The current sub-state of the Automatic DR configuration.

        Allowed values for this property are: "RESOURCE_PRINCIPAL_VALIDATION_FAILED", "DR_PLAN_NEEDS_ATTENTION", "DR_PLAN_INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_sub_state of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._lifecycle_sub_state

    @lifecycle_sub_state.setter
    def lifecycle_sub_state(self, lifecycle_sub_state):
        """
        Sets the lifecycle_sub_state of this AutomaticDrConfigurationSummary.
        The current sub-state of the Automatic DR configuration.


        :param lifecycle_sub_state: The lifecycle_sub_state of this AutomaticDrConfigurationSummary.
        :type: str
        """
        allowed_values = ["RESOURCE_PRINCIPAL_VALIDATION_FAILED", "DR_PLAN_NEEDS_ATTENTION", "DR_PLAN_INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_sub_state, allowed_values):
            lifecycle_sub_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_sub_state = lifecycle_sub_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AutomaticDrConfigurationSummary.
        A message describing the Automatic DR configuration's current state in more detail.


        :return: The lifecycle_details of this AutomaticDrConfigurationSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AutomaticDrConfigurationSummary.
        A message describing the Automatic DR configuration's current state in more detail.


        :param lifecycle_details: The lifecycle_details of this AutomaticDrConfigurationSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AutomaticDrConfigurationSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this AutomaticDrConfigurationSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AutomaticDrConfigurationSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this AutomaticDrConfigurationSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AutomaticDrConfigurationSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this AutomaticDrConfigurationSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AutomaticDrConfigurationSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this AutomaticDrConfigurationSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AutomaticDrConfigurationSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this AutomaticDrConfigurationSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AutomaticDrConfigurationSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this AutomaticDrConfigurationSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
