# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .schedule import Schedule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomSchedule(Schedule):
    """
    Custom schedule details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomSchedule object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CustomSchedule.type` attribute
        of this class is ``CUSTOM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CustomSchedule.
            Allowed values for this property are: "CUSTOM", "MAINTENANCE_WINDOW"
        :type type: str

        :param execution_startdate:
            The value to assign to the execution_startdate property of this CustomSchedule.
        :type execution_startdate: datetime

        :param recurrences:
            The value to assign to the recurrences property of this CustomSchedule.
        :type recurrences: str

        :param duration:
            The value to assign to the duration property of this CustomSchedule.
        :type duration: str

        """
        self.swagger_types = {
            'type': 'str',
            'execution_startdate': 'datetime',
            'recurrences': 'str',
            'duration': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'execution_startdate': 'executionStartdate',
            'recurrences': 'recurrences',
            'duration': 'duration'
        }
        self._type = None
        self._execution_startdate = None
        self._recurrences = None
        self._duration = None
        self._type = 'CUSTOM'

    @property
    def recurrences(self):
        """
        Gets the recurrences of this CustomSchedule.
        Recurrence rule specification if recurring


        :return: The recurrences of this CustomSchedule.
        :rtype: str
        """
        return self._recurrences

    @recurrences.setter
    def recurrences(self, recurrences):
        """
        Sets the recurrences of this CustomSchedule.
        Recurrence rule specification if recurring


        :param recurrences: The recurrences of this CustomSchedule.
        :type: str
        """
        self._recurrences = recurrences

    @property
    def duration(self):
        """
        **[Required]** Gets the duration of this CustomSchedule.
        Duration of the schedule.


        :return: The duration of this CustomSchedule.
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """
        Sets the duration of this CustomSchedule.
        Duration of the schedule.


        :param duration: The duration of this CustomSchedule.
        :type: str
        """
        self._duration = duration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
