# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportRunbookVersionDetails(object):
    """
    Request to Export Runbook Version.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImportRunbookVersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ImportRunbookVersionDetails.
        :type compartment_id: str

        :param content_source:
            The value to assign to the content_source property of this ImportRunbookVersionDetails.
        :type content_source: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param content_destination:
            The value to assign to the content_destination property of this ImportRunbookVersionDetails.
        :type content_destination: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param runbook_id:
            The value to assign to the runbook_id property of this ImportRunbookVersionDetails.
        :type runbook_id: str

        :param import_option:
            The value to assign to the import_option property of this ImportRunbookVersionDetails.
        :type import_option: str

        :param version:
            The value to assign to the version property of this ImportRunbookVersionDetails.
        :type version: str

        :param required_values:
            The value to assign to the required_values property of this ImportRunbookVersionDetails.
        :type required_values: list[oci.fleet_apps_management.models.RunbookImportRequiredValue]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'content_source': 'TransferRunbookContentDetails',
            'content_destination': 'TransferRunbookContentDetails',
            'runbook_id': 'str',
            'import_option': 'str',
            'version': 'str',
            'required_values': 'list[RunbookImportRequiredValue]'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'content_source': 'contentSource',
            'content_destination': 'contentDestination',
            'runbook_id': 'runbookId',
            'import_option': 'importOption',
            'version': 'version',
            'required_values': 'requiredValues'
        }
        self._compartment_id = None
        self._content_source = None
        self._content_destination = None
        self._runbook_id = None
        self._import_option = None
        self._version = None
        self._required_values = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ImportRunbookVersionDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this ImportRunbookVersionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ImportRunbookVersionDetails.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this ImportRunbookVersionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def content_source(self):
        """
        **[Required]** Gets the content_source of this ImportRunbookVersionDetails.

        :return: The content_source of this ImportRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_source

    @content_source.setter
    def content_source(self, content_source):
        """
        Sets the content_source of this ImportRunbookVersionDetails.

        :param content_source: The content_source of this ImportRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_source = content_source

    @property
    def content_destination(self):
        """
        **[Required]** Gets the content_destination of this ImportRunbookVersionDetails.

        :return: The content_destination of this ImportRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_destination

    @content_destination.setter
    def content_destination(self, content_destination):
        """
        Sets the content_destination of this ImportRunbookVersionDetails.

        :param content_destination: The content_destination of this ImportRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_destination = content_destination

    @property
    def runbook_id(self):
        """
        Gets the runbook_id of this ImportRunbookVersionDetails.
        The OCID of the resource.


        :return: The runbook_id of this ImportRunbookVersionDetails.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this ImportRunbookVersionDetails.
        The OCID of the resource.


        :param runbook_id: The runbook_id of this ImportRunbookVersionDetails.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def import_option(self):
        """
        Gets the import_option of this ImportRunbookVersionDetails.
        ImportOptions for Runbook.


        :return: The import_option of this ImportRunbookVersionDetails.
        :rtype: str
        """
        return self._import_option

    @import_option.setter
    def import_option(self, import_option):
        """
        Sets the import_option of this ImportRunbookVersionDetails.
        ImportOptions for Runbook.


        :param import_option: The import_option of this ImportRunbookVersionDetails.
        :type: str
        """
        self._import_option = import_option

    @property
    def version(self):
        """
        Gets the version of this ImportRunbookVersionDetails.
        Version number.


        :return: The version of this ImportRunbookVersionDetails.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ImportRunbookVersionDetails.
        Version number.


        :param version: The version of this ImportRunbookVersionDetails.
        :type: str
        """
        self._version = version

    @property
    def required_values(self):
        """
        Gets the required_values of this ImportRunbookVersionDetails.
        List of required values.


        :return: The required_values of this ImportRunbookVersionDetails.
        :rtype: list[oci.fleet_apps_management.models.RunbookImportRequiredValue]
        """
        return self._required_values

    @required_values.setter
    def required_values(self, required_values):
        """
        Sets the required_values of this ImportRunbookVersionDetails.
        List of required values.


        :param required_values: The required_values of this ImportRunbookVersionDetails.
        :type: list[oci.fleet_apps_management.models.RunbookImportRequiredValue]
        """
        self._required_values = required_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
