# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReportFilter(object):
    """
    report filters.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReportFilter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ReportFilter.
        :type name: str

        :param description:
            The value to assign to the description property of this ReportFilter.
        :type description: str

        :param value_source:
            The value to assign to the value_source property of this ReportFilter.
        :type value_source: str

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'value_source': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'value_source': 'valueSource'
        }
        self._name = None
        self._description = None
        self._value_source = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ReportFilter.
        Filter Name.


        :return: The name of this ReportFilter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ReportFilter.
        Filter Name.


        :param name: The name of this ReportFilter.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ReportFilter.
        Filter description.


        :return: The description of this ReportFilter.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ReportFilter.
        Filter description.


        :param description: The description of this ReportFilter.
        :type: str
        """
        self._description = description

    @property
    def value_source(self):
        """
        Gets the value_source of this ReportFilter.
        Filter value source.


        :return: The value_source of this ReportFilter.
        :rtype: str
        """
        return self._value_source

    @value_source.setter
    def value_source(self, value_source):
        """
        Sets the value_source of this ReportFilter.
        Filter value source.


        :param value_source: The value_source of this ReportFilter.
        :type: str
        """
        self._value_source = value_source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
