# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReportMetadataSummary(object):
    """
    Summary information about a ReportMetadata.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReportMetadataSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ReportMetadataSummary.
        :type name: str

        :param description:
            The value to assign to the description property of this ReportMetadataSummary.
        :type description: str

        :param default_order_clause:
            The value to assign to the default_order_clause property of this ReportMetadataSummary.
        :type default_order_clause: list[oci.fleet_apps_management.models.OrderClause]

        :param column_metadata:
            The value to assign to the column_metadata property of this ReportMetadataSummary.
        :type column_metadata: list[oci.fleet_apps_management.models.ColumnMetadata]

        :param metric:
            The value to assign to the metric property of this ReportMetadataSummary.
        :type metric: str

        :param filters:
            The value to assign to the filters property of this ReportMetadataSummary.
        :type filters: list[oci.fleet_apps_management.models.ReportFilter]

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'default_order_clause': 'list[OrderClause]',
            'column_metadata': 'list[ColumnMetadata]',
            'metric': 'str',
            'filters': 'list[ReportFilter]'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'default_order_clause': 'defaultOrderClause',
            'column_metadata': 'columnMetadata',
            'metric': 'metric',
            'filters': 'filters'
        }
        self._name = None
        self._description = None
        self._default_order_clause = None
        self._column_metadata = None
        self._metric = None
        self._filters = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ReportMetadataSummary.
        Name of Report.


        :return: The name of this ReportMetadataSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ReportMetadataSummary.
        Name of Report.


        :param name: The name of this ReportMetadataSummary.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ReportMetadataSummary.
        Description of report.


        :return: The description of this ReportMetadataSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ReportMetadataSummary.
        Description of report.


        :param description: The description of this ReportMetadataSummary.
        :type: str
        """
        self._description = description

    @property
    def default_order_clause(self):
        """
        Gets the default_order_clause of this ReportMetadataSummary.
        default order clause for reports.


        :return: The default_order_clause of this ReportMetadataSummary.
        :rtype: list[oci.fleet_apps_management.models.OrderClause]
        """
        return self._default_order_clause

    @default_order_clause.setter
    def default_order_clause(self, default_order_clause):
        """
        Sets the default_order_clause of this ReportMetadataSummary.
        default order clause for reports.


        :param default_order_clause: The default_order_clause of this ReportMetadataSummary.
        :type: list[oci.fleet_apps_management.models.OrderClause]
        """
        self._default_order_clause = default_order_clause

    @property
    def column_metadata(self):
        """
        Gets the column_metadata of this ReportMetadataSummary.
        Column Metadata.


        :return: The column_metadata of this ReportMetadataSummary.
        :rtype: list[oci.fleet_apps_management.models.ColumnMetadata]
        """
        return self._column_metadata

    @column_metadata.setter
    def column_metadata(self, column_metadata):
        """
        Sets the column_metadata of this ReportMetadataSummary.
        Column Metadata.


        :param column_metadata: The column_metadata of this ReportMetadataSummary.
        :type: list[oci.fleet_apps_management.models.ColumnMetadata]
        """
        self._column_metadata = column_metadata

    @property
    def metric(self):
        """
        Gets the metric of this ReportMetadataSummary.
        Metric Name.


        :return: The metric of this ReportMetadataSummary.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """
        Sets the metric of this ReportMetadataSummary.
        Metric Name.


        :param metric: The metric of this ReportMetadataSummary.
        :type: str
        """
        self._metric = metric

    @property
    def filters(self):
        """
        Gets the filters of this ReportMetadataSummary.
        metricMetadata.


        :return: The filters of this ReportMetadataSummary.
        :rtype: list[oci.fleet_apps_management.models.ReportFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this ReportMetadataSummary.
        metricMetadata.


        :param filters: The filters of this ReportMetadataSummary.
        :type: list[oci.fleet_apps_management.models.ReportFilter]
        """
        self._filters = filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
