# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GiGoalVersionDetails(object):
    """
    Details of goal 'GI' software version.
    """

    #: A constant which can be used with the goal_type property of a GiGoalVersionDetails.
    #: This constant has a value of "GI_ORACLE_IMAGE"
    GOAL_TYPE_GI_ORACLE_IMAGE = "GI_ORACLE_IMAGE"

    #: A constant which can be used with the goal_type property of a GiGoalVersionDetails.
    #: This constant has a value of "GI_CUSTOM_IMAGE"
    GOAL_TYPE_GI_CUSTOM_IMAGE = "GI_CUSTOM_IMAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new GiGoalVersionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.OracleGiGoalVersionDetails`
        * :class:`~oci.fleet_software_update.models.CustomGiGoalVersionDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param goal_type:
            The value to assign to the goal_type property of this GiGoalVersionDetails.
            Allowed values for this property are: "GI_ORACLE_IMAGE", "GI_CUSTOM_IMAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type goal_type: str

        """
        self.swagger_types = {
            'goal_type': 'str'
        }
        self.attribute_map = {
            'goal_type': 'goalType'
        }
        self._goal_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['goalType']

        if type == 'GI_ORACLE_IMAGE':
            return 'OracleGiGoalVersionDetails'

        if type == 'GI_CUSTOM_IMAGE':
            return 'CustomGiGoalVersionDetails'
        else:
            return 'GiGoalVersionDetails'

    @property
    def goal_type(self):
        """
        **[Required]** Gets the goal_type of this GiGoalVersionDetails.
        Preference to use an Oracle released 'GI' software image or a custom 'GI' software image.

        Allowed values for this property are: "GI_ORACLE_IMAGE", "GI_CUSTOM_IMAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The goal_type of this GiGoalVersionDetails.
        :rtype: str
        """
        return self._goal_type

    @goal_type.setter
    def goal_type(self, goal_type):
        """
        Sets the goal_type of this GiGoalVersionDetails.
        Preference to use an Oracle released 'GI' software image or a custom 'GI' software image.


        :param goal_type: The goal_type of this GiGoalVersionDetails.
        :type: str
        """
        allowed_values = ["GI_ORACLE_IMAGE", "GI_CUSTOM_IMAGE"]
        if not value_allowed_none_or_none_sentinel(goal_type, allowed_values):
            goal_type = 'UNKNOWN_ENUM_VALUE'
        self._goal_type = goal_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
