# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerativeAiPrivateEndpoint(object):
    """
    Generative AI private endpoint.
    """

    #: A constant which can be used with the lifecycle_state property of a GenerativeAiPrivateEndpoint.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a GenerativeAiPrivateEndpoint.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a GenerativeAiPrivateEndpoint.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a GenerativeAiPrivateEndpoint.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a GenerativeAiPrivateEndpoint.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a GenerativeAiPrivateEndpoint.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new GenerativeAiPrivateEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this GenerativeAiPrivateEndpoint.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this GenerativeAiPrivateEndpoint.
        :type display_name: str

        :param description:
            The value to assign to the description property of this GenerativeAiPrivateEndpoint.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this GenerativeAiPrivateEndpoint.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this GenerativeAiPrivateEndpoint.
        :type subnet_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this GenerativeAiPrivateEndpoint.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this GenerativeAiPrivateEndpoint.
        :type lifecycle_details: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this GenerativeAiPrivateEndpoint.
        :type nsg_ids: list[str]

        :param fqdn:
            The value to assign to the fqdn property of this GenerativeAiPrivateEndpoint.
        :type fqdn: str

        :param private_endpoint_ip:
            The value to assign to the private_endpoint_ip property of this GenerativeAiPrivateEndpoint.
        :type private_endpoint_ip: str

        :param time_created:
            The value to assign to the time_created property of this GenerativeAiPrivateEndpoint.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this GenerativeAiPrivateEndpoint.
        :type time_updated: datetime

        :param previous_state:
            The value to assign to the previous_state property of this GenerativeAiPrivateEndpoint.
        :type previous_state: oci.generative_ai.models.GenerativeAiPrivateEndpoint

        :param freeform_tags:
            The value to assign to the freeform_tags property of this GenerativeAiPrivateEndpoint.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this GenerativeAiPrivateEndpoint.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this GenerativeAiPrivateEndpoint.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'nsg_ids': 'list[str]',
            'fqdn': 'str',
            'private_endpoint_ip': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'previous_state': 'GenerativeAiPrivateEndpoint',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'nsg_ids': 'nsgIds',
            'fqdn': 'fqdn',
            'private_endpoint_ip': 'privateEndpointIp',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'previous_state': 'previousState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._subnet_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._nsg_ids = None
        self._fqdn = None
        self._private_endpoint_ip = None
        self._time_created = None
        self._time_updated = None
        self._previous_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this GenerativeAiPrivateEndpoint.
        The OCID of a private endpoint.


        :return: The id of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this GenerativeAiPrivateEndpoint.
        The OCID of a private endpoint.


        :param id: The id of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this GenerativeAiPrivateEndpoint.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :return: The display_name of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this GenerativeAiPrivateEndpoint.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :param display_name: The display_name of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this GenerativeAiPrivateEndpoint.
        A description of this private endpoint.


        :return: The description of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this GenerativeAiPrivateEndpoint.
        A description of this private endpoint.


        :param description: The description of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this GenerativeAiPrivateEndpoint.
        The OCID of the compartment that contains the private endpoint.


        :return: The compartment_id of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this GenerativeAiPrivateEndpoint.
        The OCID of the compartment that contains the private endpoint.


        :param compartment_id: The compartment_id of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this GenerativeAiPrivateEndpoint.
        The OCID of the subnet that the private endpoint belongs to.


        :return: The subnet_id of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this GenerativeAiPrivateEndpoint.
        The OCID of the subnet that the private endpoint belongs to.


        :param subnet_id: The subnet_id of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this GenerativeAiPrivateEndpoint.
        The current state of the Generative AI Private Endpoint.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this GenerativeAiPrivateEndpoint.
        The current state of the Generative AI Private Endpoint.


        :param lifecycle_state: The lifecycle_state of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this GenerativeAiPrivateEndpoint.
        The detailed messages about the lifecycle state


        :return: The lifecycle_details of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this GenerativeAiPrivateEndpoint.
        The detailed messages about the lifecycle state


        :param lifecycle_details: The lifecycle_details of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this GenerativeAiPrivateEndpoint.
        A list of the OCIDs of the network security groups that the private endpoint's VNIC belongs to.


        :return: The nsg_ids of this GenerativeAiPrivateEndpoint.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this GenerativeAiPrivateEndpoint.
        A list of the OCIDs of the network security groups that the private endpoint's VNIC belongs to.


        :param nsg_ids: The nsg_ids of this GenerativeAiPrivateEndpoint.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def fqdn(self):
        """
        **[Required]** Gets the fqdn of this GenerativeAiPrivateEndpoint.
        Fully qualified domain name the customer will use for access (for eg: xyz.oraclecloud.com)


        :return: The fqdn of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._fqdn

    @fqdn.setter
    def fqdn(self, fqdn):
        """
        Sets the fqdn of this GenerativeAiPrivateEndpoint.
        Fully qualified domain name the customer will use for access (for eg: xyz.oraclecloud.com)


        :param fqdn: The fqdn of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._fqdn = fqdn

    @property
    def private_endpoint_ip(self):
        """
        Gets the private_endpoint_ip of this GenerativeAiPrivateEndpoint.
        The private IP address (in the customer's VCN) that represents the access point for the associated endpoint service.


        :return: The private_endpoint_ip of this GenerativeAiPrivateEndpoint.
        :rtype: str
        """
        return self._private_endpoint_ip

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, private_endpoint_ip):
        """
        Sets the private_endpoint_ip of this GenerativeAiPrivateEndpoint.
        The private IP address (in the customer's VCN) that represents the access point for the associated endpoint service.


        :param private_endpoint_ip: The private_endpoint_ip of this GenerativeAiPrivateEndpoint.
        :type: str
        """
        self._private_endpoint_ip = private_endpoint_ip

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this GenerativeAiPrivateEndpoint.
        The date and time that the Generative AI private endpoint was created expressed in `RFC 3339`__ timestamp format. Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this GenerativeAiPrivateEndpoint.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this GenerativeAiPrivateEndpoint.
        The date and time that the Generative AI private endpoint was created expressed in `RFC 3339`__ timestamp format. Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this GenerativeAiPrivateEndpoint.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this GenerativeAiPrivateEndpoint.
        The date and time that the Generative AI private endpoint was updated expressed in `RFC 3339`__ timestamp format. Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this GenerativeAiPrivateEndpoint.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this GenerativeAiPrivateEndpoint.
        The date and time that the Generative AI private endpoint was updated expressed in `RFC 3339`__ timestamp format. Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this GenerativeAiPrivateEndpoint.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def previous_state(self):
        """
        Gets the previous_state of this GenerativeAiPrivateEndpoint.

        :return: The previous_state of this GenerativeAiPrivateEndpoint.
        :rtype: oci.generative_ai.models.GenerativeAiPrivateEndpoint
        """
        return self._previous_state

    @previous_state.setter
    def previous_state(self, previous_state):
        """
        Sets the previous_state of this GenerativeAiPrivateEndpoint.

        :param previous_state: The previous_state of this GenerativeAiPrivateEndpoint.
        :type: oci.generative_ai.models.GenerativeAiPrivateEndpoint
        """
        self._previous_state = previous_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this GenerativeAiPrivateEndpoint.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this GenerativeAiPrivateEndpoint.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this GenerativeAiPrivateEndpoint.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this GenerativeAiPrivateEndpoint.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this GenerativeAiPrivateEndpoint.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this GenerativeAiPrivateEndpoint.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this GenerativeAiPrivateEndpoint.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this GenerativeAiPrivateEndpoint.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this GenerativeAiPrivateEndpoint.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this GenerativeAiPrivateEndpoint.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this GenerativeAiPrivateEndpoint.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this GenerativeAiPrivateEndpoint.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
