# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChatDetails(object):
    """
    Chat details for managing user interactions and tool executions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChatDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param user_message:
            The value to assign to the user_message property of this ChatDetails.
        :type user_message: str

        :param should_stream:
            The value to assign to the should_stream property of this ChatDetails.
        :type should_stream: bool

        :param session_id:
            The value to assign to the session_id property of this ChatDetails.
        :type session_id: str

        :param tool_parameters:
            The value to assign to the tool_parameters property of this ChatDetails.
        :type tool_parameters: dict(str, str)

        :param tool_inputs:
            The value to assign to the tool_inputs property of this ChatDetails.
        :type tool_inputs: list[oci.generative_ai_agent_runtime.models.ToolInput]

        :param performed_actions:
            The value to assign to the performed_actions property of this ChatDetails.
        :type performed_actions: list[oci.generative_ai_agent_runtime.models.PerformedAction]

        """
        self.swagger_types = {
            'user_message': 'str',
            'should_stream': 'bool',
            'session_id': 'str',
            'tool_parameters': 'dict(str, str)',
            'tool_inputs': 'list[ToolInput]',
            'performed_actions': 'list[PerformedAction]'
        }
        self.attribute_map = {
            'user_message': 'userMessage',
            'should_stream': 'shouldStream',
            'session_id': 'sessionId',
            'tool_parameters': 'toolParameters',
            'tool_inputs': 'toolInputs',
            'performed_actions': 'performedActions'
        }
        self._user_message = None
        self._should_stream = None
        self._session_id = None
        self._tool_parameters = None
        self._tool_inputs = None
        self._performed_actions = None

    @property
    def user_message(self):
        """
        Gets the user_message of this ChatDetails.
        The input user message content for the chat.


        :return: The user_message of this ChatDetails.
        :rtype: str
        """
        return self._user_message

    @user_message.setter
    def user_message(self, user_message):
        """
        Sets the user_message of this ChatDetails.
        The input user message content for the chat.


        :param user_message: The user_message of this ChatDetails.
        :type: str
        """
        self._user_message = user_message

    @property
    def should_stream(self):
        """
        Gets the should_stream of this ChatDetails.
        Whether to stream the response.


        :return: The should_stream of this ChatDetails.
        :rtype: bool
        """
        return self._should_stream

    @should_stream.setter
    def should_stream(self, should_stream):
        """
        Sets the should_stream of this ChatDetails.
        Whether to stream the response.


        :param should_stream: The should_stream of this ChatDetails.
        :type: bool
        """
        self._should_stream = should_stream

    @property
    def session_id(self):
        """
        Gets the session_id of this ChatDetails.
        Optional sessionId. If not provided, will chat without any prior context.


        :return: The session_id of this ChatDetails.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this ChatDetails.
        Optional sessionId. If not provided, will chat without any prior context.


        :param session_id: The session_id of this ChatDetails.
        :type: str
        """
        self._session_id = session_id

    @property
    def tool_parameters(self):
        """
        Gets the tool_parameters of this ChatDetails.
        A map where each key is a toolId and the value contains tool type and additional dynamic parameters. This field is deprecated and will be removed after July 02 2026.


        :return: The tool_parameters of this ChatDetails.
        :rtype: dict(str, str)
        """
        return self._tool_parameters

    @tool_parameters.setter
    def tool_parameters(self, tool_parameters):
        """
        Sets the tool_parameters of this ChatDetails.
        A map where each key is a toolId and the value contains tool type and additional dynamic parameters. This field is deprecated and will be removed after July 02 2026.


        :param tool_parameters: The tool_parameters of this ChatDetails.
        :type: dict(str, str)
        """
        self._tool_parameters = tool_parameters

    @property
    def tool_inputs(self):
        """
        Gets the tool_inputs of this ChatDetails.
        Array of tool input objects, each specifying a tool's ID, type, and corresponding input parameters required for execution.


        :return: The tool_inputs of this ChatDetails.
        :rtype: list[oci.generative_ai_agent_runtime.models.ToolInput]
        """
        return self._tool_inputs

    @tool_inputs.setter
    def tool_inputs(self, tool_inputs):
        """
        Sets the tool_inputs of this ChatDetails.
        Array of tool input objects, each specifying a tool's ID, type, and corresponding input parameters required for execution.


        :param tool_inputs: The tool_inputs of this ChatDetails.
        :type: list[oci.generative_ai_agent_runtime.models.ToolInput]
        """
        self._tool_inputs = tool_inputs

    @property
    def performed_actions(self):
        """
        Gets the performed_actions of this ChatDetails.
        A list of actions that have been performed based on prior required actions.


        :return: The performed_actions of this ChatDetails.
        :rtype: list[oci.generative_ai_agent_runtime.models.PerformedAction]
        """
        return self._performed_actions

    @performed_actions.setter
    def performed_actions(self, performed_actions):
        """
        Sets the performed_actions of this ChatDetails.
        A list of actions that have been performed based on prior required actions.


        :param performed_actions: The performed_actions of this ChatDetails.
        :type: list[oci.generative_ai_agent_runtime.models.PerformedAction]
        """
        self._performed_actions = performed_actions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
