# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .source_location import SourceLocation
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciDatabaseSourceLocation(SourceLocation):
    """
    The location of the OCI Database that the agent will use.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciDatabaseSourceLocation object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.OciDatabaseSourceLocation.source_location_type` attribute
        of this class is ``OCI_DATABASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_location_type:
            The value to assign to the source_location_type property of this OciDatabaseSourceLocation.
            Allowed values for this property are: "OCI_OBJECT_STORAGE", "OCI_OPEN_SEARCH", "OCI_DATABASE"
        :type source_location_type: str

        :param id:
            The value to assign to the id property of this OciDatabaseSourceLocation.
        :type id: str

        :param function_name:
            The value to assign to the function_name property of this OciDatabaseSourceLocation.
        :type function_name: str

        :param url:
            The value to assign to the url property of this OciDatabaseSourceLocation.
        :type url: str

        """
        self.swagger_types = {
            'source_location_type': 'str',
            'id': 'str',
            'function_name': 'str',
            'url': 'str'
        }
        self.attribute_map = {
            'source_location_type': 'sourceLocationType',
            'id': 'id',
            'function_name': 'functionName',
            'url': 'url'
        }
        self._source_location_type = None
        self._id = None
        self._function_name = None
        self._url = None
        self._source_location_type = 'OCI_DATABASE'

    @property
    def id(self):
        """
        Gets the id of this OciDatabaseSourceLocation.
        The OCID of the `OCI Database Tools Connection`__.

        __ https://docs.cloud.oracle.com/iaas/database-tools/home.htm


        :return: The id of this OciDatabaseSourceLocation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OciDatabaseSourceLocation.
        The OCID of the `OCI Database Tools Connection`__.

        __ https://docs.cloud.oracle.com/iaas/database-tools/home.htm


        :param id: The id of this OciDatabaseSourceLocation.
        :type: str
        """
        self._id = id

    @property
    def function_name(self):
        """
        Gets the function_name of this OciDatabaseSourceLocation.
        The name of the function that returns source text.


        :return: The function_name of this OciDatabaseSourceLocation.
        :rtype: str
        """
        return self._function_name

    @function_name.setter
    def function_name(self, function_name):
        """
        Sets the function_name of this OciDatabaseSourceLocation.
        The name of the function that returns source text.


        :param function_name: The function_name of this OciDatabaseSourceLocation.
        :type: str
        """
        self._function_name = function_name

    @property
    def url(self):
        """
        Gets the url of this OciDatabaseSourceLocation.
        The URL of the retrieved document, if available.


        :return: The url of this OciDatabaseSourceLocation.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this OciDatabaseSourceLocation.
        The URL of the retrieved document, if available.


        :param url: The url of this OciDatabaseSourceLocation.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
