# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigureIotDomainDataAccessDetails(object):
    """
    The configuration details for IoT Domain Data Access.
    """

    #: A constant which can be used with the type property of a ConfigureIotDomainDataAccessDetails.
    #: This constant has a value of "DIRECT"
    TYPE_DIRECT = "DIRECT"

    #: A constant which can be used with the type property of a ConfigureIotDomainDataAccessDetails.
    #: This constant has a value of "ORDS"
    TYPE_ORDS = "ORDS"

    #: A constant which can be used with the type property of a ConfigureIotDomainDataAccessDetails.
    #: This constant has a value of "APEX"
    TYPE_APEX = "APEX"

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigureIotDomainDataAccessDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.iot.models.ApexDataAccessDetails`
        * :class:`~oci.iot.models.DirectDataAccessDetails`
        * :class:`~oci.iot.models.OrdsDataAccessDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ConfigureIotDomainDataAccessDetails.
            Allowed values for this property are: "DIRECT", "ORDS", "APEX"
        :type type: str

        """
        self.swagger_types = {
            'type': 'str'
        }
        self.attribute_map = {
            'type': 'type'
        }
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'APEX':
            return 'ApexDataAccessDetails'

        if type == 'DIRECT':
            return 'DirectDataAccessDetails'

        if type == 'ORDS':
            return 'OrdsDataAccessDetails'
        else:
            return 'ConfigureIotDomainDataAccessDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ConfigureIotDomainDataAccessDetails.
        configuration type

        Allowed values for this property are: "DIRECT", "ORDS", "APEX"


        :return: The type of this ConfigureIotDomainDataAccessDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ConfigureIotDomainDataAccessDetails.
        configuration type


        :param type: The type of this ConfigureIotDomainDataAccessDetails.
        :type: str
        """
        allowed_values = ["DIRECT", "ORDS", "APEX"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
