# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531

from .configure_iot_domain_data_access_details import ConfigureIotDomainDataAccessDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OrdsDataAccessDetails(ConfigureIotDomainDataAccessDetails):
    """
    This contains configuration for ORDS data access.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OrdsDataAccessDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.iot.models.OrdsDataAccessDetails.type` attribute
        of this class is ``ORDS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this OrdsDataAccessDetails.
            Allowed values for this property are: "DIRECT", "ORDS", "APEX"
        :type type: str

        :param db_allowed_identity_domain_host:
            The value to assign to the db_allowed_identity_domain_host property of this OrdsDataAccessDetails.
        :type db_allowed_identity_domain_host: str

        """
        self.swagger_types = {
            'type': 'str',
            'db_allowed_identity_domain_host': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'db_allowed_identity_domain_host': 'dbAllowedIdentityDomainHost'
        }
        self._type = None
        self._db_allowed_identity_domain_host = None
        self._type = 'ORDS'

    @property
    def db_allowed_identity_domain_host(self):
        """
        **[Required]** Gets the db_allowed_identity_domain_host of this OrdsDataAccessDetails.
        Host name of identity domain that is used for authenticating connect to data host via ORDS.


        :return: The db_allowed_identity_domain_host of this OrdsDataAccessDetails.
        :rtype: str
        """
        return self._db_allowed_identity_domain_host

    @db_allowed_identity_domain_host.setter
    def db_allowed_identity_domain_host(self, db_allowed_identity_domain_host):
        """
        Sets the db_allowed_identity_domain_host of this OrdsDataAccessDetails.
        Host name of identity domain that is used for authenticating connect to data host via ORDS.


        :param db_allowed_identity_domain_host: The db_allowed_identity_domain_host of this OrdsDataAccessDetails.
        :type: str
        """
        self._db_allowed_identity_domain_host = db_allowed_identity_domain_host

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
