# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeployedApplicationMigrationAnalysesTarget(object):
    """
    The target describes the input data for deployed Java migration analyses.
    A target contains a managed instance, deployed application installation Key, sourceJdkVersion, targetJdkVersion, optional excludePackagePrefixes
    and optional includePackagePrefixes.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DeployedApplicationMigrationAnalysesTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param managed_instance_id:
            The value to assign to the managed_instance_id property of this DeployedApplicationMigrationAnalysesTarget.
        :type managed_instance_id: str

        :param deployed_application_installation_key:
            The value to assign to the deployed_application_installation_key property of this DeployedApplicationMigrationAnalysesTarget.
        :type deployed_application_installation_key: str

        :param source_jdk_version:
            The value to assign to the source_jdk_version property of this DeployedApplicationMigrationAnalysesTarget.
        :type source_jdk_version: str

        :param target_jdk_version:
            The value to assign to the target_jdk_version property of this DeployedApplicationMigrationAnalysesTarget.
        :type target_jdk_version: str

        :param exclude_package_prefixes:
            The value to assign to the exclude_package_prefixes property of this DeployedApplicationMigrationAnalysesTarget.
        :type exclude_package_prefixes: list[str]

        :param include_package_prefixes:
            The value to assign to the include_package_prefixes property of this DeployedApplicationMigrationAnalysesTarget.
        :type include_package_prefixes: list[str]

        """
        self.swagger_types = {
            'managed_instance_id': 'str',
            'deployed_application_installation_key': 'str',
            'source_jdk_version': 'str',
            'target_jdk_version': 'str',
            'exclude_package_prefixes': 'list[str]',
            'include_package_prefixes': 'list[str]'
        }
        self.attribute_map = {
            'managed_instance_id': 'managedInstanceId',
            'deployed_application_installation_key': 'deployedApplicationInstallationKey',
            'source_jdk_version': 'sourceJdkVersion',
            'target_jdk_version': 'targetJdkVersion',
            'exclude_package_prefixes': 'excludePackagePrefixes',
            'include_package_prefixes': 'includePackagePrefixes'
        }
        self._managed_instance_id = None
        self._deployed_application_installation_key = None
        self._source_jdk_version = None
        self._target_jdk_version = None
        self._exclude_package_prefixes = None
        self._include_package_prefixes = None

    @property
    def managed_instance_id(self):
        """
        **[Required]** Gets the managed_instance_id of this DeployedApplicationMigrationAnalysesTarget.
        The OCID of the managed instance that hosts the application for which the Java migration analyses was performed.


        :return: The managed_instance_id of this DeployedApplicationMigrationAnalysesTarget.
        :rtype: str
        """
        return self._managed_instance_id

    @managed_instance_id.setter
    def managed_instance_id(self, managed_instance_id):
        """
        Sets the managed_instance_id of this DeployedApplicationMigrationAnalysesTarget.
        The OCID of the managed instance that hosts the application for which the Java migration analyses was performed.


        :param managed_instance_id: The managed_instance_id of this DeployedApplicationMigrationAnalysesTarget.
        :type: str
        """
        self._managed_instance_id = managed_instance_id

    @property
    def deployed_application_installation_key(self):
        """
        **[Required]** Gets the deployed_application_installation_key of this DeployedApplicationMigrationAnalysesTarget.
        The unique key that identifies the deployed application's installation path that is to be used for the Java migration analyses.


        :return: The deployed_application_installation_key of this DeployedApplicationMigrationAnalysesTarget.
        :rtype: str
        """
        return self._deployed_application_installation_key

    @deployed_application_installation_key.setter
    def deployed_application_installation_key(self, deployed_application_installation_key):
        """
        Sets the deployed_application_installation_key of this DeployedApplicationMigrationAnalysesTarget.
        The unique key that identifies the deployed application's installation path that is to be used for the Java migration analyses.


        :param deployed_application_installation_key: The deployed_application_installation_key of this DeployedApplicationMigrationAnalysesTarget.
        :type: str
        """
        self._deployed_application_installation_key = deployed_application_installation_key

    @property
    def source_jdk_version(self):
        """
        **[Required]** Gets the source_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        The JDK version the application is currently running on.


        :return: The source_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        :rtype: str
        """
        return self._source_jdk_version

    @source_jdk_version.setter
    def source_jdk_version(self, source_jdk_version):
        """
        Sets the source_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        The JDK version the application is currently running on.


        :param source_jdk_version: The source_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        :type: str
        """
        self._source_jdk_version = source_jdk_version

    @property
    def target_jdk_version(self):
        """
        **[Required]** Gets the target_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        The JDK version against which the migration analyses was performed to identify effort required to move from source JDK.


        :return: The target_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        :rtype: str
        """
        return self._target_jdk_version

    @target_jdk_version.setter
    def target_jdk_version(self, target_jdk_version):
        """
        Sets the target_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        The JDK version against which the migration analyses was performed to identify effort required to move from source JDK.


        :param target_jdk_version: The target_jdk_version of this DeployedApplicationMigrationAnalysesTarget.
        :type: str
        """
        self._target_jdk_version = target_jdk_version

    @property
    def exclude_package_prefixes(self):
        """
        Gets the exclude_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        Excludes the packages that starts with the prefix from the migration analyses result. Either this or includePackagePrefixes can be specified.


        :return: The exclude_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        :rtype: list[str]
        """
        return self._exclude_package_prefixes

    @exclude_package_prefixes.setter
    def exclude_package_prefixes(self, exclude_package_prefixes):
        """
        Sets the exclude_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        Excludes the packages that starts with the prefix from the migration analyses result. Either this or includePackagePrefixes can be specified.


        :param exclude_package_prefixes: The exclude_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        :type: list[str]
        """
        self._exclude_package_prefixes = exclude_package_prefixes

    @property
    def include_package_prefixes(self):
        """
        Gets the include_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        Includes the packages that starts with the prefix from the migration analyses result. Either this or excludePackagePrefixes can be specified.


        :return: The include_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        :rtype: list[str]
        """
        return self._include_package_prefixes

    @include_package_prefixes.setter
    def include_package_prefixes(self, include_package_prefixes):
        """
        Sets the include_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        Includes the packages that starts with the prefix from the migration analyses result. Either this or excludePackagePrefixes can be specified.


        :param include_package_prefixes: The include_package_prefixes of this DeployedApplicationMigrationAnalysesTarget.
        :type: list[str]
        """
        self._include_package_prefixes = include_package_prefixes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
