# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingProduct(object):
    """
    Products associated with listing.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ListingProduct object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param code:
            The value to assign to the code property of this ListingProduct.
        :type code: str

        :param categories:
            The value to assign to the categories property of this ListingProduct.
        :type categories: list[str]

        :param additional_filters:
            The value to assign to the additional_filters property of this ListingProduct.
        :type additional_filters: list[oci.marketplace_publisher.models.ListingProductAdditionalFilter]

        """
        self.swagger_types = {
            'code': 'str',
            'categories': 'list[str]',
            'additional_filters': 'list[ListingProductAdditionalFilter]'
        }
        self.attribute_map = {
            'code': 'code',
            'categories': 'categories',
            'additional_filters': 'additionalFilters'
        }
        self._code = None
        self._categories = None
        self._additional_filters = None

    @property
    def code(self):
        """
        **[Required]** Gets the code of this ListingProduct.
        Product Code


        :return: The code of this ListingProduct.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this ListingProduct.
        Product Code


        :param code: The code of this ListingProduct.
        :type: str
        """
        self._code = code

    @property
    def categories(self):
        """
        **[Required]** Gets the categories of this ListingProduct.
        List of category codes within a Product which are applicable to the listing revision.


        :return: The categories of this ListingProduct.
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """
        Sets the categories of this ListingProduct.
        List of category codes within a Product which are applicable to the listing revision.


        :param categories: The categories of this ListingProduct.
        :type: list[str]
        """
        self._categories = categories

    @property
    def additional_filters(self):
        """
        Gets the additional_filters of this ListingProduct.
        Custom filter for the product


        :return: The additional_filters of this ListingProduct.
        :rtype: list[oci.marketplace_publisher.models.ListingProductAdditionalFilter]
        """
        return self._additional_filters

    @additional_filters.setter
    def additional_filters(self, additional_filters):
        """
        Sets the additional_filters of this ListingProduct.
        Custom filter for the product


        :param additional_filters: The additional_filters of this ListingProduct.
        :type: list[oci.marketplace_publisher.models.ListingProductAdditionalFilter]
        """
        self._additional_filters = additional_filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
