# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .update_listing_revision_attachment_details import UpdateListingRevisionAttachmentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateReviewSupportDocumentAttachment(UpdateListingRevisionAttachmentDetails):
    """
    Reviewsupport document attachment for the listing revision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateReviewSupportDocumentAttachment object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.UpdateReviewSupportDocumentAttachment.attachment_type` attribute
        of this class is ``REVIEW_SUPPORT_DOCUMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateReviewSupportDocumentAttachment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateReviewSupportDocumentAttachment.
        :type description: str

        :param attachment_type:
            The value to assign to the attachment_type property of this UpdateReviewSupportDocumentAttachment.
        :type attachment_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateReviewSupportDocumentAttachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateReviewSupportDocumentAttachment.
        :type defined_tags: dict(str, dict(str, object))

        :param document_name:
            The value to assign to the document_name property of this UpdateReviewSupportDocumentAttachment.
        :type document_name: str

        :param template_code:
            The value to assign to the template_code property of this UpdateReviewSupportDocumentAttachment.
        :type template_code: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'attachment_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'document_name': 'str',
            'template_code': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'attachment_type': 'attachmentType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'document_name': 'documentName',
            'template_code': 'templateCode'
        }
        self._display_name = None
        self._description = None
        self._attachment_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._document_name = None
        self._template_code = None
        self._attachment_type = 'REVIEW_SUPPORT_DOCUMENT'

    @property
    def document_name(self):
        """
        **[Required]** Gets the document_name of this UpdateReviewSupportDocumentAttachment.
        Name of the review support document


        :return: The document_name of this UpdateReviewSupportDocumentAttachment.
        :rtype: str
        """
        return self._document_name

    @document_name.setter
    def document_name(self, document_name):
        """
        Sets the document_name of this UpdateReviewSupportDocumentAttachment.
        Name of the review support document


        :param document_name: The document_name of this UpdateReviewSupportDocumentAttachment.
        :type: str
        """
        self._document_name = document_name

    @property
    def template_code(self):
        """
        **[Required]** Gets the template_code of this UpdateReviewSupportDocumentAttachment.
        Type of review support document


        :return: The template_code of this UpdateReviewSupportDocumentAttachment.
        :rtype: str
        """
        return self._template_code

    @template_code.setter
    def template_code(self, template_code):
        """
        Sets the template_code of this UpdateReviewSupportDocumentAttachment.
        Type of review support document


        :param template_code: The template_code of this UpdateReviewSupportDocumentAttachment.
        :type: str
        """
        self._template_code = template_code

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
