# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityRuleSummary(object):
    """
    Summary for the Security Rule used in the firewall policy rules.
    Security Rules determine whether to block or allow a session based on traffic attributes,
    such as  the source and destination IP address, protocol/port, and the HTTP(S) target URL.
    """

    #: A constant which can be used with the action property of a SecurityRuleSummary.
    #: This constant has a value of "ALLOW"
    ACTION_ALLOW = "ALLOW"

    #: A constant which can be used with the action property of a SecurityRuleSummary.
    #: This constant has a value of "DROP"
    ACTION_DROP = "DROP"

    #: A constant which can be used with the action property of a SecurityRuleSummary.
    #: This constant has a value of "REJECT"
    ACTION_REJECT = "REJECT"

    #: A constant which can be used with the action property of a SecurityRuleSummary.
    #: This constant has a value of "INSPECT"
    ACTION_INSPECT = "INSPECT"

    #: A constant which can be used with the inspection property of a SecurityRuleSummary.
    #: This constant has a value of "INTRUSION_DETECTION"
    INSPECTION_INTRUSION_DETECTION = "INTRUSION_DETECTION"

    #: A constant which can be used with the inspection property of a SecurityRuleSummary.
    #: This constant has a value of "INTRUSION_PREVENTION"
    INSPECTION_INTRUSION_PREVENTION = "INTRUSION_PREVENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityRuleSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SecurityRuleSummary.
        :type name: str

        :param action:
            The value to assign to the action property of this SecurityRuleSummary.
            Allowed values for this property are: "ALLOW", "DROP", "REJECT", "INSPECT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action: str

        :param inspection:
            The value to assign to the inspection property of this SecurityRuleSummary.
            Allowed values for this property are: "INTRUSION_DETECTION", "INTRUSION_PREVENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type inspection: str

        :param priority_order:
            The value to assign to the priority_order property of this SecurityRuleSummary.
        :type priority_order: int

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this SecurityRuleSummary.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'action': 'str',
            'inspection': 'str',
            'priority_order': 'int',
            'parent_resource_id': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'action': 'action',
            'inspection': 'inspection',
            'priority_order': 'priorityOrder',
            'parent_resource_id': 'parentResourceId'
        }
        self._name = None
        self._action = None
        self._inspection = None
        self._priority_order = None
        self._parent_resource_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SecurityRuleSummary.
        Name for the Security rule, must be unique within the policy.


        :return: The name of this SecurityRuleSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SecurityRuleSummary.
        Name for the Security rule, must be unique within the policy.


        :param name: The name of this SecurityRuleSummary.
        :type: str
        """
        self._name = name

    @property
    def action(self):
        """
        **[Required]** Gets the action of this SecurityRuleSummary.
        Types of Action on the Traffic flow.

          * ALLOW - Allows the traffic.
          * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
          * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
          * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.

        Allowed values for this property are: "ALLOW", "DROP", "REJECT", "INSPECT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action of this SecurityRuleSummary.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this SecurityRuleSummary.
        Types of Action on the Traffic flow.

          * ALLOW - Allows the traffic.
          * DROP - Silently drops the traffic, e.g. without sending a TCP reset.
          * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.
          * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.


        :param action: The action of this SecurityRuleSummary.
        :type: str
        """
        allowed_values = ["ALLOW", "DROP", "REJECT", "INSPECT"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            action = 'UNKNOWN_ENUM_VALUE'
        self._action = action

    @property
    def inspection(self):
        """
        Gets the inspection of this SecurityRuleSummary.
        Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.

          * INTRUSION_DETECTION - Intrusion Detection.
          * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.

        Allowed values for this property are: "INTRUSION_DETECTION", "INTRUSION_PREVENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The inspection of this SecurityRuleSummary.
        :rtype: str
        """
        return self._inspection

    @inspection.setter
    def inspection(self, inspection):
        """
        Sets the inspection of this SecurityRuleSummary.
        Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.

          * INTRUSION_DETECTION - Intrusion Detection.
          * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.


        :param inspection: The inspection of this SecurityRuleSummary.
        :type: str
        """
        allowed_values = ["INTRUSION_DETECTION", "INTRUSION_PREVENTION"]
        if not value_allowed_none_or_none_sentinel(inspection, allowed_values):
            inspection = 'UNKNOWN_ENUM_VALUE'
        self._inspection = inspection

    @property
    def priority_order(self):
        """
        **[Required]** Gets the priority_order of this SecurityRuleSummary.
        The priority order in which this rule should be evaluated.


        :return: The priority_order of this SecurityRuleSummary.
        :rtype: int
        """
        return self._priority_order

    @priority_order.setter
    def priority_order(self, priority_order):
        """
        Sets the priority_order of this SecurityRuleSummary.
        The priority order in which this rule should be evaluated.


        :param priority_order: The priority_order of this SecurityRuleSummary.
        :type: int
        """
        self._priority_order = priority_order

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this SecurityRuleSummary.
        OCID of the network firewall policy this security rule belongs to.


        :return: The parent_resource_id of this SecurityRuleSummary.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this SecurityRuleSummary.
        OCID of the network firewall policy this security rule belongs to.


        :param parent_resource_id: The parent_resource_id of this SecurityRuleSummary.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
