# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlexTunnel(object):
    """
    Flex tunnel will set up a network tunnel between your SD-WAN appliance and DRG, allowing you to establish BGP and advertise routes.
    """

    #: A constant which can be used with the lifecycle_state property of a FlexTunnel.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a FlexTunnel.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FlexTunnel.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a FlexTunnel.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a FlexTunnel.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a FlexTunnel.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new FlexTunnel object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FlexTunnel.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this FlexTunnel.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this FlexTunnel.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this FlexTunnel.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FlexTunnel.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param drg_id:
            The value to assign to the drg_id property of this FlexTunnel.
        :type drg_id: str

        :param transport_attachment_id:
            The value to assign to the transport_attachment_id property of this FlexTunnel.
        :type transport_attachment_id: str

        :param flex_tunnel_configuration:
            The value to assign to the flex_tunnel_configuration property of this FlexTunnel.
        :type flex_tunnel_configuration: oci.vn_monitoring.models.FlexTunnelConfiguration

        :param freeform_tags:
            The value to assign to the freeform_tags property of this FlexTunnel.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this FlexTunnel.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'drg_id': 'str',
            'transport_attachment_id': 'str',
            'flex_tunnel_configuration': 'FlexTunnelConfiguration',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'drg_id': 'drgId',
            'transport_attachment_id': 'transportAttachmentId',
            'flex_tunnel_configuration': 'flexTunnelConfiguration',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._lifecycle_state = None
        self._drg_id = None
        self._transport_attachment_id = None
        self._flex_tunnel_configuration = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FlexTunnel.
        The `OCID`__ of the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this FlexTunnel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FlexTunnel.
        The `OCID`__ of the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this FlexTunnel.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FlexTunnel.
        The `OCID`__ of the compartment to contain the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this FlexTunnel.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FlexTunnel.
        The `OCID`__ of the compartment to contain the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this FlexTunnel.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this FlexTunnel.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this FlexTunnel.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FlexTunnel.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this FlexTunnel.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FlexTunnel.
        The date and time the flex tunnel was created, in the format defined
        by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this FlexTunnel.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FlexTunnel.
        The date and time the flex tunnel was created, in the format defined
        by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this FlexTunnel.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FlexTunnel.
        The current state of the flex tunnel.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"


        :return: The lifecycle_state of this FlexTunnel.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FlexTunnel.
        The current state of the flex tunnel.


        :param lifecycle_state: The lifecycle_state of this FlexTunnel.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    @property
    def drg_id(self):
        """
        **[Required]** Gets the drg_id of this FlexTunnel.
        The `OCID`__ of the drg for loopback attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The drg_id of this FlexTunnel.
        :rtype: str
        """
        return self._drg_id

    @drg_id.setter
    def drg_id(self, drg_id):
        """
        Sets the drg_id of this FlexTunnel.
        The `OCID`__ of the drg for loopback attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param drg_id: The drg_id of this FlexTunnel.
        :type: str
        """
        self._drg_id = drg_id

    @property
    def transport_attachment_id(self):
        """
        **[Required]** Gets the transport_attachment_id of this FlexTunnel.
        The `OCID`__ of the transport attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The transport_attachment_id of this FlexTunnel.
        :rtype: str
        """
        return self._transport_attachment_id

    @transport_attachment_id.setter
    def transport_attachment_id(self, transport_attachment_id):
        """
        Sets the transport_attachment_id of this FlexTunnel.
        The `OCID`__ of the transport attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param transport_attachment_id: The transport_attachment_id of this FlexTunnel.
        :type: str
        """
        self._transport_attachment_id = transport_attachment_id

    @property
    def flex_tunnel_configuration(self):
        """
        **[Required]** Gets the flex_tunnel_configuration of this FlexTunnel.

        :return: The flex_tunnel_configuration of this FlexTunnel.
        :rtype: oci.vn_monitoring.models.FlexTunnelConfiguration
        """
        return self._flex_tunnel_configuration

    @flex_tunnel_configuration.setter
    def flex_tunnel_configuration(self, flex_tunnel_configuration):
        """
        Sets the flex_tunnel_configuration of this FlexTunnel.

        :param flex_tunnel_configuration: The flex_tunnel_configuration of this FlexTunnel.
        :type: oci.vn_monitoring.models.FlexTunnelConfiguration
        """
        self._flex_tunnel_configuration = flex_tunnel_configuration

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this FlexTunnel.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this FlexTunnel.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this FlexTunnel.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this FlexTunnel.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this FlexTunnel.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this FlexTunnel.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this FlexTunnel.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this FlexTunnel.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
