# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlexTunnelBgpSession(object):
    """
    Boarder Gateway Protocol (BGP) fields.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FlexTunnelBgpSession object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_bgp_asn:
            The value to assign to the customer_bgp_asn property of this FlexTunnelBgpSession.
        :type customer_bgp_asn: str

        :param oracle_bgp_asn:
            The value to assign to the oracle_bgp_asn property of this FlexTunnelBgpSession.
        :type oracle_bgp_asn: str

        :param customer_bgp_ip:
            The value to assign to the customer_bgp_ip property of this FlexTunnelBgpSession.
        :type customer_bgp_ip: str

        :param oracle_bgp_ip:
            The value to assign to the oracle_bgp_ip property of this FlexTunnelBgpSession.
        :type oracle_bgp_ip: str

        :param customer_bgp_ipv6:
            The value to assign to the customer_bgp_ipv6 property of this FlexTunnelBgpSession.
        :type customer_bgp_ipv6: str

        :param oracle_bgp_ipv6:
            The value to assign to the oracle_bgp_ipv6 property of this FlexTunnelBgpSession.
        :type oracle_bgp_ipv6: str

        """
        self.swagger_types = {
            'customer_bgp_asn': 'str',
            'oracle_bgp_asn': 'str',
            'customer_bgp_ip': 'str',
            'oracle_bgp_ip': 'str',
            'customer_bgp_ipv6': 'str',
            'oracle_bgp_ipv6': 'str'
        }
        self.attribute_map = {
            'customer_bgp_asn': 'customerBgpAsn',
            'oracle_bgp_asn': 'oracleBgpAsn',
            'customer_bgp_ip': 'customerBgpIp',
            'oracle_bgp_ip': 'oracleBgpIp',
            'customer_bgp_ipv6': 'customerBgpIpv6',
            'oracle_bgp_ipv6': 'oracleBgpIpv6'
        }
        self._customer_bgp_asn = None
        self._oracle_bgp_asn = None
        self._customer_bgp_ip = None
        self._oracle_bgp_ip = None
        self._customer_bgp_ipv6 = None
        self._oracle_bgp_ipv6 = None

    @property
    def customer_bgp_asn(self):
        """
        **[Required]** Gets the customer_bgp_asn of this FlexTunnelBgpSession.
        The BGP ASN of the network on your end of the BGP session.


        :return: The customer_bgp_asn of this FlexTunnelBgpSession.
        :rtype: str
        """
        return self._customer_bgp_asn

    @customer_bgp_asn.setter
    def customer_bgp_asn(self, customer_bgp_asn):
        """
        Sets the customer_bgp_asn of this FlexTunnelBgpSession.
        The BGP ASN of the network on your end of the BGP session.


        :param customer_bgp_asn: The customer_bgp_asn of this FlexTunnelBgpSession.
        :type: str
        """
        self._customer_bgp_asn = customer_bgp_asn

    @property
    def oracle_bgp_asn(self):
        """
        **[Required]** Gets the oracle_bgp_asn of this FlexTunnelBgpSession.
        The Oracle BPG ASN number.


        :return: The oracle_bgp_asn of this FlexTunnelBgpSession.
        :rtype: str
        """
        return self._oracle_bgp_asn

    @oracle_bgp_asn.setter
    def oracle_bgp_asn(self, oracle_bgp_asn):
        """
        Sets the oracle_bgp_asn of this FlexTunnelBgpSession.
        The Oracle BPG ASN number.


        :param oracle_bgp_asn: The oracle_bgp_asn of this FlexTunnelBgpSession.
        :type: str
        """
        self._oracle_bgp_asn = oracle_bgp_asn

    @property
    def customer_bgp_ip(self):
        """
        **[Required]** Gets the customer_bgp_ip of this FlexTunnelBgpSession.
        This IPv4 CIDR block is for your end of the inside tunnel interface.


        :return: The customer_bgp_ip of this FlexTunnelBgpSession.
        :rtype: str
        """
        return self._customer_bgp_ip

    @customer_bgp_ip.setter
    def customer_bgp_ip(self, customer_bgp_ip):
        """
        Sets the customer_bgp_ip of this FlexTunnelBgpSession.
        This IPv4 CIDR block is for your end of the inside tunnel interface.


        :param customer_bgp_ip: The customer_bgp_ip of this FlexTunnelBgpSession.
        :type: str
        """
        self._customer_bgp_ip = customer_bgp_ip

    @property
    def oracle_bgp_ip(self):
        """
        **[Required]** Gets the oracle_bgp_ip of this FlexTunnelBgpSession.
        The IPv4 CIDR block for the Oracle end of the inside tunnel interface.


        :return: The oracle_bgp_ip of this FlexTunnelBgpSession.
        :rtype: str
        """
        return self._oracle_bgp_ip

    @oracle_bgp_ip.setter
    def oracle_bgp_ip(self, oracle_bgp_ip):
        """
        Sets the oracle_bgp_ip of this FlexTunnelBgpSession.
        The IPv4 CIDR block for the Oracle end of the inside tunnel interface.


        :param oracle_bgp_ip: The oracle_bgp_ip of this FlexTunnelBgpSession.
        :type: str
        """
        self._oracle_bgp_ip = oracle_bgp_ip

    @property
    def customer_bgp_ipv6(self):
        """
        Gets the customer_bgp_ipv6 of this FlexTunnelBgpSession.
        This IPv6 prefix is for your end of the inside tunnel interface.


        :return: The customer_bgp_ipv6 of this FlexTunnelBgpSession.
        :rtype: str
        """
        return self._customer_bgp_ipv6

    @customer_bgp_ipv6.setter
    def customer_bgp_ipv6(self, customer_bgp_ipv6):
        """
        Sets the customer_bgp_ipv6 of this FlexTunnelBgpSession.
        This IPv6 prefix is for your end of the inside tunnel interface.


        :param customer_bgp_ipv6: The customer_bgp_ipv6 of this FlexTunnelBgpSession.
        :type: str
        """
        self._customer_bgp_ipv6 = customer_bgp_ipv6

    @property
    def oracle_bgp_ipv6(self):
        """
        Gets the oracle_bgp_ipv6 of this FlexTunnelBgpSession.
        The IPv6 prefix block for the Oracle end of the inside tunnel interface.


        :return: The oracle_bgp_ipv6 of this FlexTunnelBgpSession.
        :rtype: str
        """
        return self._oracle_bgp_ipv6

    @oracle_bgp_ipv6.setter
    def oracle_bgp_ipv6(self, oracle_bgp_ipv6):
        """
        Sets the oracle_bgp_ipv6 of this FlexTunnelBgpSession.
        The IPv6 prefix block for the Oracle end of the inside tunnel interface.


        :param oracle_bgp_ipv6: The oracle_bgp_ipv6 of this FlexTunnelBgpSession.
        :type: str
        """
        self._oracle_bgp_ipv6 = oracle_bgp_ipv6

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
