# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_create_details import DrgAttachmentNetworkCreateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VirtualCircuitDrgAttachmentNetworkCreateDetails(DrgAttachmentNetworkCreateDetails):
    """
    VirtualCircuitDrgAttachmentNetworkCreateDetails model.
    """

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "100M"
    THROUGHPUT_100_M = "100M"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "200M"
    THROUGHPUT_200_M = "200M"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "500M"
    THROUGHPUT_500_M = "500M"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "1G"
    THROUGHPUT_1_G = "1G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "2G"
    THROUGHPUT_2_G = "2G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "3G"
    THROUGHPUT_3_G = "3G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "4G"
    THROUGHPUT_4_G = "4G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "5G"
    THROUGHPUT_5_G = "5G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "10G"
    THROUGHPUT_10_G = "10G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "20G"
    THROUGHPUT_20_G = "20G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "30G"
    THROUGHPUT_30_G = "30G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "40G"
    THROUGHPUT_40_G = "40G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "50G"
    THROUGHPUT_50_G = "50G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "100G"
    THROUGHPUT_100_G = "100G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "200G"
    THROUGHPUT_200_G = "200G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "400G"
    THROUGHPUT_400_G = "400G"

    #: A constant which can be used with the throughput property of a VirtualCircuitDrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "500G"
    THROUGHPUT_500_G = "500G"

    def __init__(self, **kwargs):
        """
        Initializes a new VirtualCircuitDrgAttachmentNetworkCreateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.VirtualCircuitDrgAttachmentNetworkCreateDetails.type` attribute
        of this class is ``VIRTUAL_CIRCUIT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type compartment_id: str

        :param regional_oci_asn:
            The value to assign to the regional_oci_asn property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type regional_oci_asn: str

        :param is_edge_pop:
            The value to assign to the is_edge_pop property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type is_edge_pop: bool

        :param region_name:
            The value to assign to the region_name property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type region_name: str

        :param transport_only_mode:
            The value to assign to the transport_only_mode property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type transport_only_mode: bool

        :param throughput:
            The value to assign to the throughput property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
            Allowed values for this property are: "100M", "200M", "500M", "1G", "2G", "3G", "4G", "5G", "10G", "20G", "30G", "40G", "50G", "100G", "200G", "400G", "500G"
        :type throughput: str

        :param is_whitelisted_for_ingress_disintermediation_c3:
            The value to assign to the is_whitelisted_for_ingress_disintermediation_c3 property of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type is_whitelisted_for_ingress_disintermediation_c3: bool

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'regional_oci_asn': 'str',
            'is_edge_pop': 'bool',
            'region_name': 'str',
            'transport_only_mode': 'bool',
            'throughput': 'str',
            'is_whitelisted_for_ingress_disintermediation_c3': 'bool'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'regional_oci_asn': 'regionalOciAsn',
            'is_edge_pop': 'isEdgePop',
            'region_name': 'regionName',
            'transport_only_mode': 'transportOnlyMode',
            'throughput': 'throughput',
            'is_whitelisted_for_ingress_disintermediation_c3': 'isWhitelistedForIngressDisintermediationC3'
        }
        self._type = None
        self._id = None
        self._compartment_id = None
        self._regional_oci_asn = None
        self._is_edge_pop = None
        self._region_name = None
        self._transport_only_mode = None
        self._throughput = None
        self._is_whitelisted_for_ingress_disintermediation_c3 = None
        self._type = 'VIRTUAL_CIRCUIT'

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of compartment that contains the Virtual Circuit.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of compartment that contains the Virtual Circuit.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def regional_oci_asn(self):
        """
        Gets the regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        The BGP ASN to use for the Virtual Circuit's route target


        :return: The regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._regional_oci_asn

    @regional_oci_asn.setter
    def regional_oci_asn(self, regional_oci_asn):
        """
        Sets the regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        The BGP ASN to use for the Virtual Circuit's route target


        :param regional_oci_asn: The regional_oci_asn of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._regional_oci_asn = regional_oci_asn

    @property
    def is_edge_pop(self):
        """
        Gets the is_edge_pop of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Whether the Fast Connect exists through an edge pop region.

        Example: `true`


        :return: The is_edge_pop of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: bool
        """
        return self._is_edge_pop

    @is_edge_pop.setter
    def is_edge_pop(self, is_edge_pop):
        """
        Sets the is_edge_pop of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Whether the Fast Connect exists through an edge pop region.

        Example: `true`


        :param is_edge_pop: The is_edge_pop of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: bool
        """
        self._is_edge_pop = is_edge_pop

    @property
    def region_name(self):
        """
        Gets the region_name of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        The OCI region name


        :return: The region_name of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._region_name

    @region_name.setter
    def region_name(self, region_name):
        """
        Sets the region_name of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        The OCI region name


        :param region_name: The region_name of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._region_name = region_name

    @property
    def transport_only_mode(self):
        """
        Gets the transport_only_mode of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Boolean flag that determines wether all traffic over the VCs is encrypted.

        Example: `true`


        :return: The transport_only_mode of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: bool
        """
        return self._transport_only_mode

    @transport_only_mode.setter
    def transport_only_mode(self, transport_only_mode):
        """
        Sets the transport_only_mode of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Boolean flag that determines wether all traffic over the VCs is encrypted.

        Example: `true`


        :param transport_only_mode: The transport_only_mode of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: bool
        """
        self._transport_only_mode = transport_only_mode

    @property
    def throughput(self):
        """
        Gets the throughput of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Determines Throughput capacity of Virtual Circuit.

        Example: `400G`

        Allowed values for this property are: "100M", "200M", "500M", "1G", "2G", "3G", "4G", "5G", "10G", "20G", "30G", "40G", "50G", "100G", "200G", "400G", "500G"


        :return: The throughput of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._throughput

    @throughput.setter
    def throughput(self, throughput):
        """
        Sets the throughput of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Determines Throughput capacity of Virtual Circuit.

        Example: `400G`


        :param throughput: The throughput of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        allowed_values = ["100M", "200M", "500M", "1G", "2G", "3G", "4G", "5G", "10G", "20G", "30G", "40G", "50G", "100G", "200G", "400G", "500G"]
        if not value_allowed_none_or_none_sentinel(throughput, allowed_values):
            raise ValueError(
                f"Invalid value for `throughput`, must be None or one of {allowed_values}"
            )
        self._throughput = throughput

    @property
    def is_whitelisted_for_ingress_disintermediation_c3(self):
        """
        Gets the is_whitelisted_for_ingress_disintermediation_c3 of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Determines whether the ingress traffic/routes through this attachment are disintermediated or not.

        Example: `true`


        :return: The is_whitelisted_for_ingress_disintermediation_c3 of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :rtype: bool
        """
        return self._is_whitelisted_for_ingress_disintermediation_c3

    @is_whitelisted_for_ingress_disintermediation_c3.setter
    def is_whitelisted_for_ingress_disintermediation_c3(self, is_whitelisted_for_ingress_disintermediation_c3):
        """
        Sets the is_whitelisted_for_ingress_disintermediation_c3 of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        Determines whether the ingress traffic/routes through this attachment are disintermediated or not.

        Example: `true`


        :param is_whitelisted_for_ingress_disintermediation_c3: The is_whitelisted_for_ingress_disintermediation_c3 of this VirtualCircuitDrgAttachmentNetworkCreateDetails.
        :type: bool
        """
        self._is_whitelisted_for_ingress_disintermediation_c3 = is_whitelisted_for_ingress_disintermediation_c3

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
