# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ZprDeniedSecurityActionDetails(object):
    """
    Defines details for the security action taken on zpr denied traffic.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ZprDeniedSecurityActionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_restricted_or_partial:
            The value to assign to the is_restricted_or_partial property of this ZprDeniedSecurityActionDetails.
        :type is_restricted_or_partial: bool

        :param evaluated_zpr_policies:
            The value to assign to the evaluated_zpr_policies property of this ZprDeniedSecurityActionDetails.
        :type evaluated_zpr_policies: list[oci.vn_monitoring.models.ZprPolicy]

        """
        self.swagger_types = {
            'is_restricted_or_partial': 'bool',
            'evaluated_zpr_policies': 'list[ZprPolicy]'
        }
        self.attribute_map = {
            'is_restricted_or_partial': 'isRestrictedOrPartial',
            'evaluated_zpr_policies': 'evaluatedZprPolicies'
        }
        self._is_restricted_or_partial = None
        self._evaluated_zpr_policies = None

    @property
    def is_restricted_or_partial(self):
        """
        **[Required]** Gets the is_restricted_or_partial of this ZprDeniedSecurityActionDetails.
        If true, the evaluated zpr policy ID details are incomplete.


        :return: The is_restricted_or_partial of this ZprDeniedSecurityActionDetails.
        :rtype: bool
        """
        return self._is_restricted_or_partial

    @is_restricted_or_partial.setter
    def is_restricted_or_partial(self, is_restricted_or_partial):
        """
        Sets the is_restricted_or_partial of this ZprDeniedSecurityActionDetails.
        If true, the evaluated zpr policy ID details are incomplete.


        :param is_restricted_or_partial: The is_restricted_or_partial of this ZprDeniedSecurityActionDetails.
        :type: bool
        """
        self._is_restricted_or_partial = is_restricted_or_partial

    @property
    def evaluated_zpr_policies(self):
        """
        Gets the evaluated_zpr_policies of this ZprDeniedSecurityActionDetails.
        The list of evaluated zpr policies associated with the OCI resource.


        :return: The evaluated_zpr_policies of this ZprDeniedSecurityActionDetails.
        :rtype: list[oci.vn_monitoring.models.ZprPolicy]
        """
        return self._evaluated_zpr_policies

    @evaluated_zpr_policies.setter
    def evaluated_zpr_policies(self, evaluated_zpr_policies):
        """
        Sets the evaluated_zpr_policies of this ZprDeniedSecurityActionDetails.
        The list of evaluated zpr policies associated with the OCI resource.


        :param evaluated_zpr_policies: The evaluated_zpr_policies of this ZprDeniedSecurityActionDetails.
        :type: list[oci.vn_monitoring.models.ZprPolicy]
        """
        self._evaluated_zpr_policies = evaluated_zpr_policies

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
