# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WlsDomainCredential(object):
    """
    Details of the WebLogic and Node Manager credentials.
    """

    #: A constant which can be used with the strategy property of a WlsDomainCredential.
    #: This constant has a value of "USE_DOMAIN_CONFIG"
    STRATEGY_USE_DOMAIN_CONFIG = "USE_DOMAIN_CONFIG"

    #: A constant which can be used with the strategy property of a WlsDomainCredential.
    #: This constant has a value of "USE_NODE_MANAGER_CONFIG"
    STRATEGY_USE_NODE_MANAGER_CONFIG = "USE_NODE_MANAGER_CONFIG"

    #: A constant which can be used with the strategy property of a WlsDomainCredential.
    #: This constant has a value of "USE_SECRETS"
    STRATEGY_USE_SECRETS = "USE_SECRETS"

    def __init__(self, **kwargs):
        """
        Initializes a new WlsDomainCredential object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this WlsDomainCredential.
        :type type: str

        :param strategy:
            The value to assign to the strategy property of this WlsDomainCredential.
            Allowed values for this property are: "USE_DOMAIN_CONFIG", "USE_NODE_MANAGER_CONFIG", "USE_SECRETS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type strategy: str

        :param user_secret_id:
            The value to assign to the user_secret_id property of this WlsDomainCredential.
        :type user_secret_id: str

        :param password_secret_id:
            The value to assign to the password_secret_id property of this WlsDomainCredential.
        :type password_secret_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'strategy': 'str',
            'user_secret_id': 'str',
            'password_secret_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'strategy': 'strategy',
            'user_secret_id': 'userSecretId',
            'password_secret_id': 'passwordSecretId'
        }
        self._type = None
        self._strategy = None
        self._user_secret_id = None
        self._password_secret_id = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this WlsDomainCredential.
        The type of credential.


        :return: The type of this WlsDomainCredential.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this WlsDomainCredential.
        The type of credential.


        :param type: The type of this WlsDomainCredential.
        :type: str
        """
        self._type = type

    @property
    def strategy(self):
        """
        Gets the strategy of this WlsDomainCredential.
        The strategy for passing the new credentials.

        Allowed values for this property are: "USE_DOMAIN_CONFIG", "USE_NODE_MANAGER_CONFIG", "USE_SECRETS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The strategy of this WlsDomainCredential.
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """
        Sets the strategy of this WlsDomainCredential.
        The strategy for passing the new credentials.


        :param strategy: The strategy of this WlsDomainCredential.
        :type: str
        """
        allowed_values = ["USE_DOMAIN_CONFIG", "USE_NODE_MANAGER_CONFIG", "USE_SECRETS"]
        if not value_allowed_none_or_none_sentinel(strategy, allowed_values):
            strategy = 'UNKNOWN_ENUM_VALUE'
        self._strategy = strategy

    @property
    def user_secret_id(self):
        """
        Gets the user_secret_id of this WlsDomainCredential.
        The OCID for user secret.


        :return: The user_secret_id of this WlsDomainCredential.
        :rtype: str
        """
        return self._user_secret_id

    @user_secret_id.setter
    def user_secret_id(self, user_secret_id):
        """
        Sets the user_secret_id of this WlsDomainCredential.
        The OCID for user secret.


        :param user_secret_id: The user_secret_id of this WlsDomainCredential.
        :type: str
        """
        self._user_secret_id = user_secret_id

    @property
    def password_secret_id(self):
        """
        Gets the password_secret_id of this WlsDomainCredential.
        The OCID for password secret.


        :return: The password_secret_id of this WlsDomainCredential.
        :rtype: str
        """
        return self._password_secret_id

    @password_secret_id.setter
    def password_secret_id(self, password_secret_id):
        """
        Sets the password_secret_id of this WlsDomainCredential.
        The OCID for password secret.


        :param password_secret_id: The password_secret_id of this WlsDomainCredential.
        :type: str
        """
        self._password_secret_id = password_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
