# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateRemediationRecipeDetails(object):
    """
    Details to update an existing remediation recipe.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateRemediationRecipeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateRemediationRecipeDetails.
        :type display_name: str

        :param scm_configuration:
            The value to assign to the scm_configuration property of this UpdateRemediationRecipeDetails.
        :type scm_configuration: oci.adm.models.ScmConfiguration

        :param verify_configuration:
            The value to assign to the verify_configuration property of this UpdateRemediationRecipeDetails.
        :type verify_configuration: oci.adm.models.VerifyConfiguration

        :param detect_configuration:
            The value to assign to the detect_configuration property of this UpdateRemediationRecipeDetails.
        :type detect_configuration: oci.adm.models.DetectConfiguration

        :param network_configuration:
            The value to assign to the network_configuration property of this UpdateRemediationRecipeDetails.
        :type network_configuration: oci.adm.models.NetworkConfiguration

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this UpdateRemediationRecipeDetails.
        :type knowledge_base_id: str

        :param is_run_triggered_on_kb_change:
            The value to assign to the is_run_triggered_on_kb_change property of this UpdateRemediationRecipeDetails.
        :type is_run_triggered_on_kb_change: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateRemediationRecipeDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateRemediationRecipeDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'scm_configuration': 'ScmConfiguration',
            'verify_configuration': 'VerifyConfiguration',
            'detect_configuration': 'DetectConfiguration',
            'network_configuration': 'NetworkConfiguration',
            'knowledge_base_id': 'str',
            'is_run_triggered_on_kb_change': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'scm_configuration': 'scmConfiguration',
            'verify_configuration': 'verifyConfiguration',
            'detect_configuration': 'detectConfiguration',
            'network_configuration': 'networkConfiguration',
            'knowledge_base_id': 'knowledgeBaseId',
            'is_run_triggered_on_kb_change': 'isRunTriggeredOnKbChange',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._scm_configuration = None
        self._verify_configuration = None
        self._detect_configuration = None
        self._network_configuration = None
        self._knowledge_base_id = None
        self._is_run_triggered_on_kb_change = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateRemediationRecipeDetails.
        The name of the remediation recipe.


        :return: The display_name of this UpdateRemediationRecipeDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateRemediationRecipeDetails.
        The name of the remediation recipe.


        :param display_name: The display_name of this UpdateRemediationRecipeDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def scm_configuration(self):
        """
        Gets the scm_configuration of this UpdateRemediationRecipeDetails.

        :return: The scm_configuration of this UpdateRemediationRecipeDetails.
        :rtype: oci.adm.models.ScmConfiguration
        """
        return self._scm_configuration

    @scm_configuration.setter
    def scm_configuration(self, scm_configuration):
        """
        Sets the scm_configuration of this UpdateRemediationRecipeDetails.

        :param scm_configuration: The scm_configuration of this UpdateRemediationRecipeDetails.
        :type: oci.adm.models.ScmConfiguration
        """
        self._scm_configuration = scm_configuration

    @property
    def verify_configuration(self):
        """
        Gets the verify_configuration of this UpdateRemediationRecipeDetails.

        :return: The verify_configuration of this UpdateRemediationRecipeDetails.
        :rtype: oci.adm.models.VerifyConfiguration
        """
        return self._verify_configuration

    @verify_configuration.setter
    def verify_configuration(self, verify_configuration):
        """
        Sets the verify_configuration of this UpdateRemediationRecipeDetails.

        :param verify_configuration: The verify_configuration of this UpdateRemediationRecipeDetails.
        :type: oci.adm.models.VerifyConfiguration
        """
        self._verify_configuration = verify_configuration

    @property
    def detect_configuration(self):
        """
        Gets the detect_configuration of this UpdateRemediationRecipeDetails.

        :return: The detect_configuration of this UpdateRemediationRecipeDetails.
        :rtype: oci.adm.models.DetectConfiguration
        """
        return self._detect_configuration

    @detect_configuration.setter
    def detect_configuration(self, detect_configuration):
        """
        Sets the detect_configuration of this UpdateRemediationRecipeDetails.

        :param detect_configuration: The detect_configuration of this UpdateRemediationRecipeDetails.
        :type: oci.adm.models.DetectConfiguration
        """
        self._detect_configuration = detect_configuration

    @property
    def network_configuration(self):
        """
        Gets the network_configuration of this UpdateRemediationRecipeDetails.

        :return: The network_configuration of this UpdateRemediationRecipeDetails.
        :rtype: oci.adm.models.NetworkConfiguration
        """
        return self._network_configuration

    @network_configuration.setter
    def network_configuration(self, network_configuration):
        """
        Sets the network_configuration of this UpdateRemediationRecipeDetails.

        :param network_configuration: The network_configuration of this UpdateRemediationRecipeDetails.
        :type: oci.adm.models.NetworkConfiguration
        """
        self._network_configuration = network_configuration

    @property
    def knowledge_base_id(self):
        """
        Gets the knowledge_base_id of this UpdateRemediationRecipeDetails.
        The Oracle Cloud Identifier (`OCID`__) of the knowledge base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this UpdateRemediationRecipeDetails.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this UpdateRemediationRecipeDetails.
        The Oracle Cloud Identifier (`OCID`__) of the knowledge base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this UpdateRemediationRecipeDetails.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    @property
    def is_run_triggered_on_kb_change(self):
        """
        Gets the is_run_triggered_on_kb_change of this UpdateRemediationRecipeDetails.
        Boolean indicating if a run should be automatically triggered once the knowledge base is updated.


        :return: The is_run_triggered_on_kb_change of this UpdateRemediationRecipeDetails.
        :rtype: bool
        """
        return self._is_run_triggered_on_kb_change

    @is_run_triggered_on_kb_change.setter
    def is_run_triggered_on_kb_change(self, is_run_triggered_on_kb_change):
        """
        Sets the is_run_triggered_on_kb_change of this UpdateRemediationRecipeDetails.
        Boolean indicating if a run should be automatically triggered once the knowledge base is updated.


        :param is_run_triggered_on_kb_change: The is_run_triggered_on_kb_change of this UpdateRemediationRecipeDetails.
        :type: bool
        """
        self._is_run_triggered_on_kb_change = is_run_triggered_on_kb_change

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateRemediationRecipeDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateRemediationRecipeDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateRemediationRecipeDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateRemediationRecipeDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateRemediationRecipeDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateRemediationRecipeDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateRemediationRecipeDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateRemediationRecipeDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
