# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NormalizationFieldsMapValue(object):
    """
    Object for the value in the NormalizationFields map
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NormalizationFieldsMapValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param normalization_type:
            The value to assign to the normalization_type property of this NormalizationFieldsMapValue.
        :type normalization_type: str

        """
        self.swagger_types = {
            'normalization_type': 'str'
        }
        self.attribute_map = {
            'normalization_type': 'normalizationType'
        }
        self._normalization_type = None

    @property
    def normalization_type(self):
        """
        Gets the normalization_type of this NormalizationFieldsMapValue.
        A string mapping to the normalization type.


        :return: The normalization_type of this NormalizationFieldsMapValue.
        :rtype: str
        """
        return self._normalization_type

    @normalization_type.setter
    def normalization_type(self, normalization_type):
        """
        Sets the normalization_type of this NormalizationFieldsMapValue.
        A string mapping to the normalization type.


        :param normalization_type: The normalization_type of this NormalizationFieldsMapValue.
        :type: str
        """
        self._normalization_type = normalization_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
