# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateJobDetails(object):
    """
    Job creation detail which will have documents on which language services need to run prediction along with output folder
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateJobDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateJobDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateJobDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateJobDetails.
        :type compartment_id: str

        :param input_location:
            The value to assign to the input_location property of this CreateJobDetails.
        :type input_location: oci.ai_language.models.InputLocation

        :param input_configuration:
            The value to assign to the input_configuration property of this CreateJobDetails.
        :type input_configuration: oci.ai_language.models.InputConfiguration

        :param model_metadata_details:
            The value to assign to the model_metadata_details property of this CreateJobDetails.
        :type model_metadata_details: list[oci.ai_language.models.ModelMetadataDetails]

        :param output_location:
            The value to assign to the output_location property of this CreateJobDetails.
        :type output_location: oci.ai_language.models.ObjectPrefixOutputLocation

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'input_location': 'InputLocation',
            'input_configuration': 'InputConfiguration',
            'model_metadata_details': 'list[ModelMetadataDetails]',
            'output_location': 'ObjectPrefixOutputLocation'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'input_location': 'inputLocation',
            'input_configuration': 'inputConfiguration',
            'model_metadata_details': 'modelMetadataDetails',
            'output_location': 'outputLocation'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._input_location = None
        self._input_configuration = None
        self._model_metadata_details = None
        self._output_location = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateJobDetails.
        A user-friendly display name for the job.


        :return: The display_name of this CreateJobDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateJobDetails.
        A user-friendly display name for the job.


        :param display_name: The display_name of this CreateJobDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateJobDetails.
        A short description of the job.


        :return: The description of this CreateJobDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateJobDetails.
        A short description of the job.


        :param description: The description of this CreateJobDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateJobDetails.
        The `OCID`__ of the compartment where you want to create the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateJobDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateJobDetails.
        The `OCID`__ of the compartment where you want to create the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateJobDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def input_location(self):
        """
        **[Required]** Gets the input_location of this CreateJobDetails.

        :return: The input_location of this CreateJobDetails.
        :rtype: oci.ai_language.models.InputLocation
        """
        return self._input_location

    @input_location.setter
    def input_location(self, input_location):
        """
        Sets the input_location of this CreateJobDetails.

        :param input_location: The input_location of this CreateJobDetails.
        :type: oci.ai_language.models.InputLocation
        """
        self._input_location = input_location

    @property
    def input_configuration(self):
        """
        Gets the input_configuration of this CreateJobDetails.

        :return: The input_configuration of this CreateJobDetails.
        :rtype: oci.ai_language.models.InputConfiguration
        """
        return self._input_configuration

    @input_configuration.setter
    def input_configuration(self, input_configuration):
        """
        Sets the input_configuration of this CreateJobDetails.

        :param input_configuration: The input_configuration of this CreateJobDetails.
        :type: oci.ai_language.models.InputConfiguration
        """
        self._input_configuration = input_configuration

    @property
    def model_metadata_details(self):
        """
        **[Required]** Gets the model_metadata_details of this CreateJobDetails.
        training model details
        For this release only one model is allowed to be input here.
        One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API


        :return: The model_metadata_details of this CreateJobDetails.
        :rtype: list[oci.ai_language.models.ModelMetadataDetails]
        """
        return self._model_metadata_details

    @model_metadata_details.setter
    def model_metadata_details(self, model_metadata_details):
        """
        Sets the model_metadata_details of this CreateJobDetails.
        training model details
        For this release only one model is allowed to be input here.
        One of the three modelType, ModelId, endpointId should be given other wise error will be thrown from API


        :param model_metadata_details: The model_metadata_details of this CreateJobDetails.
        :type: list[oci.ai_language.models.ModelMetadataDetails]
        """
        self._model_metadata_details = model_metadata_details

    @property
    def output_location(self):
        """
        **[Required]** Gets the output_location of this CreateJobDetails.

        :return: The output_location of this CreateJobDetails.
        :rtype: oci.ai_language.models.ObjectPrefixOutputLocation
        """
        return self._output_location

    @output_location.setter
    def output_location(self, output_location):
        """
        Sets the output_location of this CreateJobDetails.

        :param output_location: The output_location of this CreateJobDetails.
        :type: oci.ai_language.models.ObjectPrefixOutputLocation
        """
        self._output_location = output_location

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
