# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Customization(object):
    """
    Description of a Customization.
    """

    #: A constant which can be used with the lifecycle_state property of a Customization.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Customization.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Customization.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Customization.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Customization.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Customization.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    def __init__(self, **kwargs):
        """
        Initializes a new Customization object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Customization.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Customization.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Customization.
        :type compartment_id: str

        :param alias:
            The value to assign to the alias property of this Customization.
        :type alias: str

        :param description:
            The value to assign to the description property of this Customization.
        :type description: str

        :param model_details:
            The value to assign to the model_details property of this Customization.
        :type model_details: oci.ai_speech.models.CustomizationModelDetails

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Customization.
            Allowed values for this property are: "DELETING", "DELETED", "FAILED", "UPDATING", "ACTIVE", "CREATING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Customization.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this Customization.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Customization.
        :type time_updated: datetime

        :param training_dataset:
            The value to assign to the training_dataset property of this Customization.
        :type training_dataset: oci.ai_speech.models.CustomizationDatasetDetails

        :param entities:
            The value to assign to the entities property of this Customization.
        :type entities: list[oci.ai_speech.models.CustomizationReferencedEntities]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Customization.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Customization.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Customization.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'alias': 'str',
            'description': 'str',
            'model_details': 'CustomizationModelDetails',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'training_dataset': 'CustomizationDatasetDetails',
            'entities': 'list[CustomizationReferencedEntities]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'alias': 'alias',
            'description': 'description',
            'model_details': 'modelDetails',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'training_dataset': 'trainingDataset',
            'entities': 'entities',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._alias = None
        self._description = None
        self._model_details = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._training_dataset = None
        self._entities = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Customization.
        The `OCID`__ of the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this Customization.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Customization.
        The `OCID`__ of the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this Customization.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this Customization.
        A user-friendly display name for the job.


        :return: The display_name of this Customization.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Customization.
        A user-friendly display name for the job.


        :param display_name: The display_name of this Customization.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Customization.
        The `OCID`__ of the compartment where you want to create the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Customization.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Customization.
        The `OCID`__ of the compartment where you want to create the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Customization.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def alias(self):
        """
        Gets the alias of this Customization.
        Customization Details Alias


        :return: The alias of this Customization.
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """
        Sets the alias of this Customization.
        Customization Details Alias


        :param alias: The alias of this Customization.
        :type: str
        """
        self._alias = alias

    @property
    def description(self):
        """
        Gets the description of this Customization.
        A short description of the job.


        :return: The description of this Customization.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Customization.
        A short description of the job.


        :param description: The description of this Customization.
        :type: str
        """
        self._description = description

    @property
    def model_details(self):
        """
        **[Required]** Gets the model_details of this Customization.

        :return: The model_details of this Customization.
        :rtype: oci.ai_speech.models.CustomizationModelDetails
        """
        return self._model_details

    @model_details.setter
    def model_details(self, model_details):
        """
        Sets the model_details of this Customization.

        :param model_details: The model_details of this Customization.
        :type: oci.ai_speech.models.CustomizationModelDetails
        """
        self._model_details = model_details

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this Customization.
        The current state of the Job.

        Allowed values for this property are: "DELETING", "DELETED", "FAILED", "UPDATING", "ACTIVE", "CREATING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Customization.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Customization.
        The current state of the Job.


        :param lifecycle_state: The lifecycle_state of this Customization.
        :type: str
        """
        allowed_values = ["DELETING", "DELETED", "FAILED", "UPDATING", "ACTIVE", "CREATING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Customization.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this Customization.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Customization.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this Customization.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this Customization.
        Customization Created time. An RFC3339 formatted datetime string.


        :return: The time_created of this Customization.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Customization.
        Customization Created time. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this Customization.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Customization.
        Customization Updated time. An RFC3339 formatted datetime string.


        :return: The time_updated of this Customization.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Customization.
        Customization Updated time. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this Customization.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def training_dataset(self):
        """
        Gets the training_dataset of this Customization.

        :return: The training_dataset of this Customization.
        :rtype: oci.ai_speech.models.CustomizationDatasetDetails
        """
        return self._training_dataset

    @training_dataset.setter
    def training_dataset(self, training_dataset):
        """
        Sets the training_dataset of this Customization.

        :param training_dataset: The training_dataset of this Customization.
        :type: oci.ai_speech.models.CustomizationDatasetDetails
        """
        self._training_dataset = training_dataset

    @property
    def entities(self):
        """
        Gets the entities of this Customization.
        array of referenced entities


        :return: The entities of this Customization.
        :rtype: list[oci.ai_speech.models.CustomizationReferencedEntities]
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """
        Sets the entities of this Customization.
        array of referenced entities


        :param entities: The entities of this Customization.
        :type: list[oci.ai_speech.models.CustomizationReferencedEntities]
        """
        self._entities = entities

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Customization.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`.


        :return: The freeform_tags of this Customization.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Customization.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`.


        :param freeform_tags: The freeform_tags of this Customization.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Customization.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace-1\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}, \"foo-namespace-2\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}}`.


        :return: The defined_tags of this Customization.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Customization.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace-1\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}, \"foo-namespace-2\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}}`.


        :param defined_tags: The defined_tags of this Customization.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Customization.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`.


        :return: The system_tags of this Customization.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Customization.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`.


        :param system_tags: The system_tags of this Customization.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
