# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeMessageResultTranscription(object):
    """
    Transcription object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeMessageResultTranscription object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param transcription:
            The value to assign to the transcription property of this RealtimeMessageResultTranscription.
        :type transcription: str

        :param is_final:
            The value to assign to the is_final property of this RealtimeMessageResultTranscription.
        :type is_final: bool

        :param start_time_in_ms:
            The value to assign to the start_time_in_ms property of this RealtimeMessageResultTranscription.
        :type start_time_in_ms: int

        :param end_time_in_ms:
            The value to assign to the end_time_in_ms property of this RealtimeMessageResultTranscription.
        :type end_time_in_ms: int

        :param confidence:
            The value to assign to the confidence property of this RealtimeMessageResultTranscription.
        :type confidence: float

        :param trailing_silence:
            The value to assign to the trailing_silence property of this RealtimeMessageResultTranscription.
        :type trailing_silence: int

        :param tokens:
            The value to assign to the tokens property of this RealtimeMessageResultTranscription.
        :type tokens: list[oci.ai_speech.models.RealtimeMessageResultTranscriptionToken]

        """
        self.swagger_types = {
            'transcription': 'str',
            'is_final': 'bool',
            'start_time_in_ms': 'int',
            'end_time_in_ms': 'int',
            'confidence': 'float',
            'trailing_silence': 'int',
            'tokens': 'list[RealtimeMessageResultTranscriptionToken]'
        }
        self.attribute_map = {
            'transcription': 'transcription',
            'is_final': 'isFinal',
            'start_time_in_ms': 'startTimeInMs',
            'end_time_in_ms': 'endTimeInMs',
            'confidence': 'confidence',
            'trailing_silence': 'trailingSilence',
            'tokens': 'tokens'
        }
        self._transcription = None
        self._is_final = None
        self._start_time_in_ms = None
        self._end_time_in_ms = None
        self._confidence = None
        self._trailing_silence = None
        self._tokens = None

    @property
    def transcription(self):
        """
        **[Required]** Gets the transcription of this RealtimeMessageResultTranscription.
        Transcription text.


        :return: The transcription of this RealtimeMessageResultTranscription.
        :rtype: str
        """
        return self._transcription

    @transcription.setter
    def transcription(self, transcription):
        """
        Sets the transcription of this RealtimeMessageResultTranscription.
        Transcription text.


        :param transcription: The transcription of this RealtimeMessageResultTranscription.
        :type: str
        """
        self._transcription = transcription

    @property
    def is_final(self):
        """
        **[Required]** Gets the is_final of this RealtimeMessageResultTranscription.
        Whether the transcription is final or partial.


        :return: The is_final of this RealtimeMessageResultTranscription.
        :rtype: bool
        """
        return self._is_final

    @is_final.setter
    def is_final(self, is_final):
        """
        Sets the is_final of this RealtimeMessageResultTranscription.
        Whether the transcription is final or partial.


        :param is_final: The is_final of this RealtimeMessageResultTranscription.
        :type: bool
        """
        self._is_final = is_final

    @property
    def start_time_in_ms(self):
        """
        **[Required]** Gets the start_time_in_ms of this RealtimeMessageResultTranscription.
        Start time in milliseconds for the transcription text.


        :return: The start_time_in_ms of this RealtimeMessageResultTranscription.
        :rtype: int
        """
        return self._start_time_in_ms

    @start_time_in_ms.setter
    def start_time_in_ms(self, start_time_in_ms):
        """
        Sets the start_time_in_ms of this RealtimeMessageResultTranscription.
        Start time in milliseconds for the transcription text.


        :param start_time_in_ms: The start_time_in_ms of this RealtimeMessageResultTranscription.
        :type: int
        """
        self._start_time_in_ms = start_time_in_ms

    @property
    def end_time_in_ms(self):
        """
        **[Required]** Gets the end_time_in_ms of this RealtimeMessageResultTranscription.
        End time in milliseconds for the transcription text.


        :return: The end_time_in_ms of this RealtimeMessageResultTranscription.
        :rtype: int
        """
        return self._end_time_in_ms

    @end_time_in_ms.setter
    def end_time_in_ms(self, end_time_in_ms):
        """
        Sets the end_time_in_ms of this RealtimeMessageResultTranscription.
        End time in milliseconds for the transcription text.


        :param end_time_in_ms: The end_time_in_ms of this RealtimeMessageResultTranscription.
        :type: int
        """
        self._end_time_in_ms = end_time_in_ms

    @property
    def confidence(self):
        """
        **[Required]** Gets the confidence of this RealtimeMessageResultTranscription.
        Confidence for the transcription text.


        :return: The confidence of this RealtimeMessageResultTranscription.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this RealtimeMessageResultTranscription.
        Confidence for the transcription text.


        :param confidence: The confidence of this RealtimeMessageResultTranscription.
        :type: float
        """
        self._confidence = confidence

    @property
    def trailing_silence(self):
        """
        **[Required]** Gets the trailing_silence of this RealtimeMessageResultTranscription.
        Trailing silence after the transcription text.


        :return: The trailing_silence of this RealtimeMessageResultTranscription.
        :rtype: int
        """
        return self._trailing_silence

    @trailing_silence.setter
    def trailing_silence(self, trailing_silence):
        """
        Sets the trailing_silence of this RealtimeMessageResultTranscription.
        Trailing silence after the transcription text.


        :param trailing_silence: The trailing_silence of this RealtimeMessageResultTranscription.
        :type: int
        """
        self._trailing_silence = trailing_silence

    @property
    def tokens(self):
        """
        **[Required]** Gets the tokens of this RealtimeMessageResultTranscription.
        Array of individual transcription tokens.


        :return: The tokens of this RealtimeMessageResultTranscription.
        :rtype: list[oci.ai_speech.models.RealtimeMessageResultTranscriptionToken]
        """
        return self._tokens

    @tokens.setter
    def tokens(self, tokens):
        """
        Sets the tokens of this RealtimeMessageResultTranscription.
        Array of individual transcription tokens.


        :param tokens: The tokens of this RealtimeMessageResultTranscription.
        :type: list[oci.ai_speech.models.RealtimeMessageResultTranscriptionToken]
        """
        self._tokens = tokens

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
