# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .stream_network_access_details import StreamNetworkAccessDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateStreamNetworkAccessDetails(StreamNetworkAccessDetails):
    """
    Details of private endpoint to connect to stream
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateStreamNetworkAccessDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_vision.models.PrivateStreamNetworkAccessDetails.stream_access_type` attribute
        of this class is ``PRIVATE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stream_access_type:
            The value to assign to the stream_access_type property of this PrivateStreamNetworkAccessDetails.
            Allowed values for this property are: "PRIVATE"
        :type stream_access_type: str

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this PrivateStreamNetworkAccessDetails.
        :type private_endpoint_id: str

        """
        self.swagger_types = {
            'stream_access_type': 'str',
            'private_endpoint_id': 'str'
        }
        self.attribute_map = {
            'stream_access_type': 'streamAccessType',
            'private_endpoint_id': 'privateEndpointId'
        }
        self._stream_access_type = None
        self._private_endpoint_id = None
        self._stream_access_type = 'PRIVATE'

    @property
    def private_endpoint_id(self):
        """
        **[Required]** Gets the private_endpoint_id of this PrivateStreamNetworkAccessDetails.
        `OCID`__ of the private Endpoint

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The private_endpoint_id of this PrivateStreamNetworkAccessDetails.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this PrivateStreamNetworkAccessDetails.
        `OCID`__ of the private Endpoint

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param private_endpoint_id: The private_endpoint_id of this PrivateStreamNetworkAccessDetails.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
