# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StreamNetworkAccessDetails(object):
    """
    Details about a stream Connection type
    """

    #: A constant which can be used with the stream_access_type property of a StreamNetworkAccessDetails.
    #: This constant has a value of "PRIVATE"
    STREAM_ACCESS_TYPE_PRIVATE = "PRIVATE"

    def __init__(self, **kwargs):
        """
        Initializes a new StreamNetworkAccessDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.ai_vision.models.PrivateStreamNetworkAccessDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stream_access_type:
            The value to assign to the stream_access_type property of this StreamNetworkAccessDetails.
            Allowed values for this property are: "PRIVATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type stream_access_type: str

        """
        self.swagger_types = {
            'stream_access_type': 'str'
        }
        self.attribute_map = {
            'stream_access_type': 'streamAccessType'
        }
        self._stream_access_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['streamAccessType']

        if type == 'PRIVATE':
            return 'PrivateStreamNetworkAccessDetails'
        else:
            return 'StreamNetworkAccessDetails'

    @property
    def stream_access_type(self):
        """
        **[Required]** Gets the stream_access_type of this StreamNetworkAccessDetails.
        Type of access
        Allowed values are:
        - PRIVATE

        Allowed values for this property are: "PRIVATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The stream_access_type of this StreamNetworkAccessDetails.
        :rtype: str
        """
        return self._stream_access_type

    @stream_access_type.setter
    def stream_access_type(self, stream_access_type):
        """
        Sets the stream_access_type of this StreamNetworkAccessDetails.
        Type of access
        Allowed values are:
        - PRIVATE


        :param stream_access_type: The stream_access_type of this StreamNetworkAccessDetails.
        :type: str
        """
        allowed_values = ["PRIVATE"]
        if not value_allowed_none_or_none_sentinel(stream_access_type, allowed_values):
            stream_access_type = 'UNKNOWN_ENUM_VALUE'
        self._stream_access_type = stream_access_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
